/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Joiner;
import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.fusesource.jansi.Ansi;

public class PlainTextReporter
extends ReportModelVisitor {
    private static final String INDENT = "   ";
    private static final boolean COLOR_DISABLED = Config.config().textColorEnabled();
    protected final PrintStream stream;
    private int maxFillWordLength;
    private ScenarioModel currentScenarioModel;
    private final boolean withColor;

    public static String toString(ReportModel model) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PlainTextReporter textWriter = new PlainTextReporter(new PrintStream(stream), false);
        textWriter.write(model);
        return stream.toString();
    }

    public PlainTextReporter() {
        this(!COLOR_DISABLED);
    }

    public PlainTextReporter(boolean withColor) {
        this(System.out, withColor);
    }

    public PlainTextReporter(OutputStream outputStream, boolean withColor) {
        this(new PrintStream(outputStream), withColor);
    }

    private PlainTextReporter(PrintStream stream, boolean withColor) {
        this.withColor = withColor;
        this.stream = stream;
    }

    @Override
    public void visit(ReportModel multiScenarioModel) {
        this.stream.println();
        String title = this.withColor(Ansi.Color.RED, Ansi.Attribute.INTENSITY_BOLD, "Test Class: ");
        title = title + this.withColor(Ansi.Color.RED, multiScenarioModel.className);
        this.println(Ansi.Color.RED, title);
    }

    private void println(Ansi.Color color, String text) {
        this.stream.println(this.withColor(color, text));
    }

    private String withColor(Ansi.Color color, String text) {
        return this.withColor(color, false, null, text);
    }

    private String withColor(Ansi.Color color, Ansi.Attribute attribute, String text) {
        return this.withColor(color, false, attribute, text);
    }

    private String withColor(Ansi.Color color, boolean bright, Ansi.Attribute attribute, String text) {
        if (this.withColor) {
            Ansi ansi;
            Ansi ansi2 = ansi = bright ? Ansi.ansi().fgBright(color) : Ansi.ansi().fg(color);
            if (attribute != null) {
                ansi = ansi.a(attribute);
            }
            return ansi.a(text).reset().toString();
        }
        return text;
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        this.stream.print("\n" + this.withColor(Ansi.Color.MAGENTA, Ansi.Attribute.INTENSITY_BOLD, " Scenario: "));
        this.println(Ansi.Color.MAGENTA, scenarioModel.description + "\n");
        this.currentScenarioModel = scenarioModel;
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (!scenarioCase.success) {
            this.stream.println();
            this.stream.print("FAILED: " + scenarioCase.errorMessage);
        }
        this.stream.println();
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        if (this.currentScenarioModel.scenarioCases.size() > 1) {
            this.stream.print("  Case " + scenarioCase.caseNr + ": ");
            List<String> arguments = scenarioCase.arguments;
            if (arguments.isEmpty()) {
                this.stream.println();
            } else {
                List<String> parameterNames = this.currentScenarioModel.parameterNames;
                for (int i = 0; i < arguments.size(); ++i) {
                    if (i < parameterNames.size()) {
                        this.stream.print(parameterNames.get(i) + " = ");
                    }
                    this.stream.print(arguments.get(i));
                    if (i == arguments.size() - 1) continue;
                    this.stream.print(", ");
                }
                this.stream.println();
            }
        }
        this.maxFillWordLength = new MaxFillWordLengthGetter().getLength(scenarioCase);
    }

    @Override
    public void visit(StepModel stepModel) {
        String intro = "";
        List<Word> words = stepModel.words;
        if (words.get((int)0).isIntroWord) {
            intro = this.withColor(Ansi.Color.BLUE, Ansi.Attribute.INTENSITY_BOLD, INDENT + String.format("%" + this.maxFillWordLength + "s ", WordUtil.capitalize(words.get((int)0).value)));
        }
        String rest = Joiner.on((String)" ").join(words.subList(1, words.size()));
        if (stepModel.notImplementedYet) {
            rest = this.withColor(Ansi.Color.BLACK, true, Ansi.Attribute.INTENSITY_FAINT, rest + " (not implemented yet)");
        } else if (stepModel.failed) {
            rest = this.withColor(Ansi.Color.RED, true, Ansi.Attribute.INTENSITY_FAINT, rest);
            rest = rest + this.withColor(Ansi.Color.RED, true, Ansi.Attribute.INTENSITY_BOLD, " (failed)");
        }
        this.stream.println(intro + rest);
    }

    public void write(ReportModel model) {
        model.accept(this);
    }

    public void write(ScenarioModel scenarioModel) {
        scenarioModel.accept(this);
    }

    static class MaxFillWordLengthGetter
    extends ReportModelVisitor {
        private int maxLength;

        MaxFillWordLengthGetter() {
        }

        public int getLength(ScenarioCaseModel scenarioCase) {
            scenarioCase.accept(this);
            return this.maxLength;
        }

        @Override
        public void visit(StepModel stepModel) {
            int length;
            Word word = stepModel.words.get(0);
            if (word.isIntroWord && (length = word.value.length()) > this.maxLength) {
                this.maxLength = length;
            }
        }
    }
}

