/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.config;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.TagDescriptionGenerator;
import com.tngtech.jgiven.annotation.TagHrefGenerator;
import com.tngtech.jgiven.impl.tag.DefaultTagDescriptionGenerator;
import com.tngtech.jgiven.impl.tag.DefaultTagHrefGenerator;
import java.lang.annotation.Annotation;
import java.util.List;

public class TagConfiguration {
    private final String annotationType;
    private boolean ignoreValue;
    private boolean explodeArray = true;
    private boolean prependType;
    private String defaultValue = "";
    private String description = "";
    private String color = "";
    private String cssClass = "";
    private String style = "";
    private Class<? extends TagDescriptionGenerator> descriptionGenerator = DefaultTagDescriptionGenerator.class;
    private String name = "";
    private List<String> tags = Lists.newArrayList();
    private String href = "";
    private Class<? extends TagHrefGenerator> hrefGenerator = DefaultTagHrefGenerator.class;

    public TagConfiguration(Class<? extends Annotation> tagAnnotation) {
        this.annotationType = tagAnnotation.getSimpleName();
    }

    public static Builder builder(Class<? extends Annotation> tagAnnotation) {
        return new Builder(new TagConfiguration(tagAnnotation));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends TagDescriptionGenerator> getDescriptionGenerator() {
        return this.descriptionGenerator;
    }

    @Deprecated
    public String getType() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExplodeArray() {
        return this.explodeArray;
    }

    public boolean isIgnoreValue() {
        return this.ignoreValue;
    }

    public boolean isPrependType() {
        return this.prependType;
    }

    public String getColor() {
        return this.color;
    }

    public String getStyle() {
        return this.style;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public String getHref() {
        return this.href;
    }

    public Class<? extends TagHrefGenerator> getHrefGenerator() {
        return this.hrefGenerator;
    }

    public static class Builder {
        final TagConfiguration configuration;

        Builder(TagConfiguration configuration) {
            this.configuration = configuration;
        }

        public Builder ignoreValue(boolean b) {
            this.configuration.ignoreValue = b;
            return this;
        }

        public Builder explodeArray(boolean b) {
            this.configuration.explodeArray = b;
            return this;
        }

        public Builder defaultValue(String s) {
            this.configuration.defaultValue = s;
            return this;
        }

        public Builder description(String s) {
            this.configuration.description = s;
            return this;
        }

        public Builder descriptionGenerator(Class<? extends TagDescriptionGenerator> descriptionGenerator) {
            this.configuration.descriptionGenerator = descriptionGenerator;
            return this;
        }

        @Deprecated
        public Builder type(String s) {
            this.configuration.name = s;
            return this;
        }

        public Builder name(String s) {
            this.configuration.name = s;
            return this;
        }

        public Builder prependType(boolean b) {
            this.configuration.prependType = b;
            return this;
        }

        public Builder cssClass(String cssClass) {
            this.configuration.cssClass = cssClass;
            return this;
        }

        public Builder color(String color) {
            this.configuration.color = color;
            return this;
        }

        public Builder style(String style) {
            this.configuration.style = style;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.configuration.tags = tags;
            return this;
        }

        public Builder href(String s) {
            this.configuration.href = s;
            return this;
        }

        public Builder hrefGenerator(Class<? extends TagHrefGenerator> hrefGenerator) {
            this.configuration.hrefGenerator = hrefGenerator;
            return this;
        }

        public TagConfiguration build() {
            return this.configuration;
        }
    }
}

