/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.json;

import com.tngtech.jgiven.report.ReportGenerator;
import com.tngtech.jgiven.report.json.JsonModelTraverser;
import com.tngtech.jgiven.report.json.ReportModelFileHandler;
import com.tngtech.jgiven.report.model.CompleteReportModel;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import java.io.File;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportModelReader
implements ReportModelFileHandler {
    private static final Logger log = LoggerFactory.getLogger(ReportModelReader.class);
    private final ReportGenerator.Config config;
    private CompleteReportModel completeModelReport = new CompleteReportModel();

    public ReportModelReader(ReportGenerator.Config config) {
        this.config = config;
    }

    public CompleteReportModel readDirectory(File sourceDir) {
        new JsonModelTraverser().traverseModels(sourceDir, this);
        return this.completeModelReport;
    }

    @Override
    public void handleReportModel(ReportModelFile modelFile) {
        if (modelFile.model.getClassName() == null) {
            log.error("ClassName in report model is null for file " + modelFile.file + ". Skipping.");
            return;
        }
        if (this.config.getExcludeEmptyScenarios()) {
            log.info("Removing empty scenarios...");
            this.removeEmptyScenarios(modelFile.model);
            if (!modelFile.model.getScenarios().isEmpty()) {
                log.debug("File " + modelFile.file + " has only empty scenarios. Skipping.");
                this.completeModelReport.addModelFile(modelFile);
            }
        } else {
            this.completeModelReport.addModelFile(modelFile);
        }
    }

    void removeEmptyScenarios(ReportModel modelFile) {
        Iterator<ScenarioModel> scenarios = modelFile.getScenarios().iterator();
        while (scenarios.hasNext()) {
            ScenarioModel scenarioModel = scenarios.next();
            this.removeEmptyCase(scenarioModel);
            if (!scenarioModel.getScenarioCases().isEmpty()) continue;
            scenarios.remove();
        }
    }

    private void removeEmptyCase(ScenarioModel scenarioModel) {
        Iterator<ScenarioCaseModel> cases = scenarioModel.getScenarioCases().iterator();
        while (cases.hasNext()) {
            ScenarioCaseModel theCase = cases.next();
            if (!theCase.getSteps().isEmpty()) continue;
            cases.remove();
        }
    }
}

