/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ExecutionStatusCalculator;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ScenarioCaseModel {
    private int caseNr;
    private List<StepModel> steps = Lists.newArrayList();
    private List<String> explicitArguments = Lists.newArrayList();
    private List<String> derivedArguments = Lists.newArrayList();
    private boolean success = true;
    private String errorMessage;
    private List<String> stackTrace;
    private long durationInNanos;
    private String description;

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        for (StepModel step : this.getSteps()) {
            step.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    public void addExplicitArguments(String ... args) {
        this.explicitArguments.addAll(Arrays.asList(args));
    }

    public void setExplicitArguments(List<String> arguments) {
        this.explicitArguments.clear();
        this.explicitArguments.addAll(arguments);
    }

    public List<String> getExplicitArguments() {
        return Collections.unmodifiableList(this.explicitArguments);
    }

    public void addStep(StepModel stepModel) {
        this.steps.add(stepModel);
    }

    public StepModel getStep(int i) {
        return this.steps.get(i);
    }

    public List<StepModel> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void setDurationInNanos(long durationInNanos) {
        this.durationInNanos = durationInNanos;
    }

    public long getDurationInNanos() {
        return this.durationInNanos;
    }

    public ExecutionStatus getExecutionStatus() {
        ExecutionStatusCalculator executionStatusCalculator = new ExecutionStatusCalculator();
        this.accept(executionStatusCalculator);
        return executionStatusCalculator.executionStatus();
    }

    public void addDerivedArguments(String ... values) {
        this.derivedArguments.addAll(Arrays.asList(values));
    }

    public List<String> getDerivedArguments() {
        return Collections.unmodifiableList(this.derivedArguments);
    }

    public int getCaseNr() {
        return this.caseNr;
    }

    public void setCaseNr(int caseNr) {
        this.caseNr = caseNr;
    }

    public void setSteps(List<StepModel> steps) {
        this.steps = steps;
    }

    public StepModel getFirstStep() {
        return this.steps.get(0);
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(List<String> stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public void setDerivedArguments(List<String> derivedArguments) {
        this.derivedArguments.clear();
        this.derivedArguments.addAll(derivedArguments);
    }
}

