/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.AnnotationArgumentFormatter;
import com.tngtech.jgiven.format.ArgumentFormatter;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.Formatter;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.format.table.TableFormatter;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StepFormatter {
    private final String stepDescription;
    private final List<NamedArgument> arguments;
    private final List<ObjectFormatter<?>> formatters;

    public StepFormatter(String stepDescription, List<NamedArgument> arguments, List<ObjectFormatter<?>> formatters) {
        this.stepDescription = stepDescription;
        this.arguments = arguments;
        this.formatters = formatters;
    }

    public List<Word> buildFormattedWords() {
        try {
            return this.buildFormattedWordsInternal();
        }
        catch (JGivenWrongUsageException e) {
            throw new JGivenWrongUsageException(e.getMessage() + ". Step definition: " + this.stepDescription);
        }
    }

    private List<Word> buildFormattedWordsInternal() {
        ArrayList formattedWords = Lists.newArrayList();
        int argCount = 0;
        StringBuilder currentWord = new StringBuilder();
        for (int i = 0; i < this.stepDescription.length(); ++i) {
            char ch = this.stepDescription.charAt(i);
            if (ch == '$') {
                if (i + 1 < this.stepDescription.length() && this.stepDescription.charAt(i + 1) == '$') {
                    currentWord.append("$");
                    ++i;
                    continue;
                }
                if (currentWord.length() > 0) {
                    if (currentWord.charAt(currentWord.length() - 1) == ' ') {
                        currentWord.setLength(currentWord.length() - 1);
                    }
                    formattedWords.add(new Word(currentWord.toString()));
                    currentWord.setLength(0);
                }
                i = this.readPlaceholder(i + 1, this.stepDescription, currentWord);
                this.addArgument(formattedWords, argCount, currentWord);
                ++argCount;
                currentWord.setLength(0);
                continue;
            }
            currentWord.append(ch);
        }
        if (currentWord.length() > 0) {
            formattedWords.add(new Word(currentWord.toString()));
        }
        formattedWords.addAll(this.getRemainingArguments(argCount));
        return formattedWords;
    }

    private int readPlaceholder(int start, String stepDescription, StringBuilder currentWord) {
        char ch;
        int i;
        for (i = start; i < stepDescription.length() && Character.isJavaIdentifierPart(ch = stepDescription.charAt(i)) && ch != '$'; ++i) {
            currentWord.append(ch);
        }
        if (i < stepDescription.length() && stepDescription.charAt(i) != ' ') {
            return i - 1;
        }
        return i;
    }

    private List<Word> getRemainingArguments(int argCount) {
        ArrayList remainingArguments = Lists.newArrayList();
        for (int i = argCount; i < this.arguments.size(); ++i) {
            Object value = this.arguments.get((int)i).value;
            String formattedValue = this.formatUsingFormatterOrNull(this.formatters.get(i), value);
            if (formattedValue == null && this.formatters.get(i) != null && this.formatters.get(i) instanceof TableFormatting) {
                DataTable dataTable = ((TableFormatting)this.formatters.get(i)).formatTable(value);
                remainingArguments.add(Word.argWord(this.arguments.get((int)i).name, StepFormatter.toDefaultStringFormat(value), dataTable));
                continue;
            }
            remainingArguments.add(Word.argWord(this.arguments.get((int)i).name, StepFormatter.toDefaultStringFormat(value), formattedValue));
        }
        return remainingArguments;
    }

    private void addArgument(List<Word> formattedWords, int argCount, CharSequence word) {
        Pattern pattern = Pattern.compile("(\\d+)");
        Matcher matcher = pattern.matcher(word);
        int index = argCount;
        if (matcher.matches()) {
            int argIndex = Integer.parseInt(matcher.group(1));
            index = argIndex - 1;
        }
        if (index >= this.arguments.size()) {
            throw new JGivenWrongUsageException("The step definition has more placeholders than arguments");
        }
        Object value = this.arguments.get((int)index).value;
        String defaultFormattedValue = StepFormatter.toDefaultStringFormat(value);
        ObjectFormatter<?> formatter = this.formatters.get(index);
        String formattedValue = this.formatUsingFormatterOrNull(formatter, value);
        String argumentName = WordUtil.fromSnakeCase(this.arguments.get((int)index).name);
        formattedWords.add(Word.argWord(argumentName, defaultFormattedValue, formattedValue));
    }

    private <T> String formatUsingFormatterOrNull(ObjectFormatter<T> argumentFormatter, Object value) {
        if (argumentFormatter == null) {
            return null;
        }
        return argumentFormatter.format(value);
    }

    private static String toDefaultStringFormat(Object value) {
        return new DefaultFormatter<Object>().format(value);
    }

    public static class TableFormatting<F extends TableFormatter>
    extends Formatting<F, Object> {
        private final Table tableAnnotation;
        private final String parameterName;
        private final Annotation[] annotations;

        public TableFormatting(F formatter, Table tableAnnotation, String parameterName, Annotation ... annotations) {
            super(formatter);
            this.tableAnnotation = tableAnnotation;
            this.parameterName = parameterName;
            this.annotations = annotations;
        }

        @Override
        public String format(Object o) {
            return null;
        }

        public DataTable formatTable(Object o) {
            return ((TableFormatter)this.formatter).format(o, this.tableAnnotation, this.parameterName, this.annotations);
        }
    }

    public static class AnnotationBasedFormatter
    implements ArgumentFormatter {
        private final AnnotationArgumentFormatter formatter;
        private final Annotation annotation;

        public AnnotationBasedFormatter(AnnotationArgumentFormatter formatter, Annotation annotation) {
            this.formatter = formatter;
            this.annotation = annotation;
        }

        public String format(Object argumentToFormat, String ... formatterArguments) {
            return this.formatter.format(argumentToFormat, this.annotation);
        }
    }

    public static class ArgumentFormatting<F extends ArgumentFormatter<T>, T>
    extends Formatting<F, T> {
        private final String[] args;

        public ArgumentFormatting(F formatter, String ... args) {
            super(formatter);
            this.args = args;
        }

        @Override
        public String format(T o) {
            return ((ArgumentFormatter)this.formatter).format(o, this.args);
        }
    }

    public static class TypeBasedFormatting<T>
    extends Formatting<Formatter<T>, T> {
        private final Annotation[] annotations;

        public TypeBasedFormatting(Formatter<T> formatter, Annotation[] annotations) {
            super(formatter);
            this.annotations = annotations;
        }

        @Override
        public String format(T o) {
            return ((Formatter)this.formatter).format(o, this.annotations);
        }
    }

    public static abstract class Formatting<F, T>
    implements ObjectFormatter<T> {
        protected final F formatter;

        Formatting(F formatter) {
            this.formatter = formatter;
        }

        @Override
        public abstract String format(T var1);

        public F getFormatter() {
            return this.formatter;
        }
    }
}

