/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.tngtech.jgiven.impl.params.DefaultCaseDescriptionProvider;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Word;
import com.tngtech.jgiven.report.text.PlainTextTableWriter;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.util.List;
import org.fusesource.jansi.Ansi;

public class PlainTextScenarioWriter
extends PlainTextWriter {
    private static final String INDENT = "   ";
    public static final String NESTED_HEADING = "  ";
    public static final String NESTED_INDENT = "  ";
    protected ScenarioModel currentScenarioModel;
    protected ScenarioCaseModel currentCaseModel;
    private int maxFillWordLength;

    public PlainTextScenarioWriter(PrintWriter printWriter, boolean withColor) {
        super(printWriter, withColor);
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        this.writer.print("\n" + this.withColor(Ansi.Color.MAGENTA, Ansi.Attribute.INTENSITY_BOLD, " Scenario: "));
        this.println(Ansi.Color.MAGENTA, scenarioModel.getDescription() + "\n");
        this.currentScenarioModel = scenarioModel;
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (!scenarioCase.isSuccess()) {
            this.writer.println();
            this.writer.print("FAILED: " + scenarioCase.getErrorMessage());
        }
        this.writer.println();
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        if (this.currentScenarioModel.getScenarioCases().size() > 1) {
            this.printCaseLine(scenarioCase);
        }
        this.maxFillWordLength = new MaxFillWordLengthGetter().getLength(scenarioCase);
        this.currentCaseModel = scenarioCase;
    }

    protected void printCaseLine(ScenarioCaseModel scenarioCase) {
        this.writer.print("  Case " + scenarioCase.getCaseNr() + ": ");
        this.writer.print(this.getDescriptionOrDefault(scenarioCase));
        this.writer.println();
    }

    public String getDescriptionOrDefault(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.hasDescription()) {
            return scenarioCase.getDescription();
        }
        return DefaultCaseDescriptionProvider.defaultDescription(this.currentScenarioModel.getExplicitParameters(), scenarioCase.getExplicitArguments());
    }

    @Override
    public void visit(StepModel stepModel) {
        this.printStep(stepModel, 0, false);
    }

    private void printStep(StepModel stepModel, int depth, boolean showPassed) {
        Word lastWord;
        List<Word> words = stepModel.words;
        String introString = this.getIntroString(words, depth);
        int restSize = words.size();
        boolean printDataTable = false;
        if (words.size() > 1 && (lastWord = words.get(words.size() - 1)).isArg() && lastWord.getArgumentInfo().isDataTable()) {
            --restSize;
            printDataTable = true;
        }
        int introWordIndex = words.get(0).isIntroWord() ? 1 : 0;
        String rest = this.joinWords(words.subList(introWordIndex, restSize));
        if (stepModel.isPending()) {
            rest = this.withColor(Ansi.Color.BLACK, true, Ansi.Attribute.INTENSITY_FAINT, rest + " (pending)");
        } else if (stepModel.isSkipped()) {
            rest = this.withColor(Ansi.Color.BLACK, true, Ansi.Attribute.INTENSITY_FAINT, rest + " (skipped)");
        } else if (stepModel.isFailed()) {
            rest = this.withColor(Ansi.Color.RED, true, Ansi.Attribute.INTENSITY_FAINT, rest);
            rest = rest + this.withColor(Ansi.Color.RED, true, Ansi.Attribute.INTENSITY_BOLD, " (failed)");
        } else if (showPassed) {
            rest = rest + " (passed)";
        }
        this.writer.println(introString + rest);
        this.printNestedSteps(stepModel, depth);
        if (printDataTable) {
            this.writer.println();
            this.printDataTable(words.get(words.size() - 1));
        }
    }

    private String getIntroString(List<Word> words, int depth) {
        String intro;
        if (depth > 0) {
            intro = INDENT + String.format("%" + this.maxFillWordLength + "s ", " ") + Strings.repeat((String)"  ", (int)(depth - 1)) + "  ";
            if (words.get(0).isIntroWord()) {
                intro = intro + this.withColor(Ansi.Color.BLUE, Ansi.Attribute.INTENSITY_BOLD, WordUtil.capitalize(words.get(0).getValue())) + " ";
            }
        } else {
            intro = words.get(0).isIntroWord() ? INDENT + this.withColor(Ansi.Color.BLUE, Ansi.Attribute.INTENSITY_BOLD, String.format("%" + this.maxFillWordLength + "s ", WordUtil.capitalize(words.get(0).getValue()))) : INDENT + String.format("%" + this.maxFillWordLength + "s ", " ");
        }
        return intro;
    }

    private void printNestedSteps(StepModel stepModel, int depth) {
        for (StepModel nestedStepModel : stepModel.getNestedSteps()) {
            this.printStep(nestedStepModel, depth + 1, stepModel.getStatus() == StepStatus.FAILED);
        }
    }

    private void printDataTable(Word word) {
        PlainTextTableWriter plainTextTableWriter = new PlainTextTableWriter(this.writer, this.withColor);
        String indent = "     ";
        plainTextTableWriter.writeDataTable(word.getArgumentInfo().getDataTable(), indent);
        this.writer.println();
    }

    private String joinWords(List<Word> words) {
        return Joiner.on((String)" ").join(Iterables.transform(words, (Function)new Function<Word, String>(){

            public String apply(Word input) {
                return PlainTextScenarioWriter.this.wordToString(input);
            }
        }));
    }

    protected String wordToString(Word word) {
        if (word.isArg() && !this.isInt(word)) {
            return word.getFormattedValue();
        }
        return word.getValue();
    }

    private boolean isInt(Word word) {
        try {
            Integer.valueOf(word.getFormattedValue());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static class MaxFillWordLengthGetter
    extends ReportModelVisitor {
        private int maxLength = 1;

        MaxFillWordLengthGetter() {
        }

        public int getLength(ScenarioCaseModel scenarioCase) {
            scenarioCase.accept(this);
            return this.maxLength;
        }

        @Override
        public void visit(StepModel stepModel) {
            int length;
            Word word = stepModel.words.get(0);
            if (word.isIntroWord() && (length = word.getValue().length()) > this.maxLength) {
                this.maxLength = length;
            }
        }
    }
}

