/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.CurrentScenario;
import com.tngtech.jgiven.CurrentStep;
import com.tngtech.jgiven.annotation.AfterScenario;
import com.tngtech.jgiven.annotation.AfterStage;
import com.tngtech.jgiven.annotation.BeforeScenario;
import com.tngtech.jgiven.annotation.BeforeStage;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.annotation.ScenarioRule;
import com.tngtech.jgiven.annotation.ScenarioStage;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.exception.FailIfPassedException;
import com.tngtech.jgiven.exception.JGivenUserException;
import com.tngtech.jgiven.impl.ScenarioExecutor;
import com.tngtech.jgiven.impl.inject.ValueInjector;
import com.tngtech.jgiven.impl.intercept.NoOpScenarioListener;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.intercept.StageTransitionHandler;
import com.tngtech.jgiven.impl.intercept.StandaloneStepMethodInterceptor;
import com.tngtech.jgiven.impl.intercept.StepMethodHandler;
import com.tngtech.jgiven.impl.util.FieldCache;
import com.tngtech.jgiven.impl.util.ParameterNameUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.integration.CanWire;
import com.tngtech.jgiven.report.model.InvocationMode;
import com.tngtech.jgiven.report.model.NamedArgument;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneScenarioExecutor
implements ScenarioExecutor {
    private static final Logger log = LoggerFactory.getLogger(StandaloneScenarioExecutor.class);
    private Object currentTopLevelStage;
    private ScenarioExecutor.State state = ScenarioExecutor.State.INIT;
    private boolean beforeScenarioMethodsExecuted;
    private boolean executeLifeCycleMethods = true;
    protected final Map<Class<?>, StageState> stages = Maps.newLinkedHashMap();
    private final List<Object> scenarioRules = Lists.newArrayList();
    private final ValueInjector injector = new ValueInjector();
    private ScenarioListener listener = new NoOpScenarioListener();
    protected final StepMethodHandler methodHandler = new MethodHandler();
    protected final StageTransitionHandler stageTransitionHandler = new StageTransitionHandlerImpl();
    private final StandaloneStepMethodInterceptor methodInterceptor = new StandaloneStepMethodInterceptor(this.methodHandler, this.stageTransitionHandler);
    private Throwable failedException;
    private boolean failIfPass;
    private boolean suppressExceptions;

    public StandaloneScenarioExecutor() {
        this.injector.injectValueByType(StandaloneScenarioExecutor.class, this);
        this.injector.injectValueByType(CurrentStep.class, new StepAccessImpl());
        this.injector.injectValueByType(CurrentScenario.class, new ScenarioAccessImpl());
    }

    @Override
    public <T> T addStage(Class<T> stepsClass) {
        if (this.stages.containsKey(stepsClass)) {
            return (T)this.stages.get(stepsClass).instance;
        }
        T result = this.createStageClass(stepsClass);
        this.stages.put(stepsClass, new StageState(result));
        this.gatherRules(result);
        this.injectStages(result);
        return result;
    }

    @Override
    public <T> T createStageClass(Class<T> stepsClass) {
        Enhancer e = new Enhancer();
        e.setSuperclass(stepsClass);
        e.setCallback((Callback)this.methodInterceptor);
        Object result = e.create();
        this.methodInterceptor.enableMethodHandling(true);
        return (T)result;
    }

    @Override
    public void addIntroWord(String word) {
        this.listener.introWordAdded(word);
    }

    private void gatherRules(Object stage) {
        for (Field field : FieldCache.get(stage.getClass()).getFieldsWithAnnotation(ScenarioRule.class)) {
            log.debug("Found rule in field {} ", (Object)field);
            try {
                this.scenarioRules.add(field.get(stage));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while reading field " + field, e);
            }
        }
    }

    private <T> void updateScenarioState(T t) {
        this.injector.updateValues(t);
    }

    private boolean afterStageMethodsCalled(Object stage) {
        return this.getStageState((Object)stage).afterStageCalled;
    }

    private boolean executeAfterStageMethods(Object stage) throws Throwable {
        StageState stageState = this.getStageState(stage);
        if (stageState.afterStageCalled) {
            return false;
        }
        stageState.afterStageCalled = true;
        this.executeAnnotatedMethods(stage, AfterStage.class);
        return true;
    }

    public StageState getStageState(Object stage) {
        return this.stages.get(stage.getClass().getSuperclass());
    }

    private void ensureBeforeScenarioMethodsAreExecuted() throws Throwable {
        if (this.state != ScenarioExecutor.State.INIT) {
            return;
        }
        this.state = ScenarioExecutor.State.STARTED;
        this.methodInterceptor.enableMethodHandling(false);
        try {
            for (Object rule : this.scenarioRules) {
                this.invokeRuleMethod(rule, "before");
            }
            this.beforeScenarioMethodsExecuted = true;
            for (StageState stage : this.stages.values()) {
                this.executeBeforeScenarioMethods(stage.instance);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            this.finished();
            throw e;
        }
        this.methodInterceptor.enableMethodHandling(true);
    }

    private void executeAnnotatedMethods(Object stage, final Class<? extends Annotation> annotationClass) throws Throwable {
        if (!this.executeLifeCycleMethods) {
            return;
        }
        log.debug("Executing methods annotated with @{}", (Object)annotationClass.getName());
        boolean previousMethodExecution = this.methodInterceptor.enableMethodExecution(true);
        try {
            this.methodInterceptor.enableMethodHandling(false);
            ReflectionUtil.forEachMethod(stage, stage.getClass(), annotationClass, new ReflectionUtil.MethodAction(){

                @Override
                public void act(Object object, Method method) throws Exception {
                    ReflectionUtil.invokeMethod(object, method, " with annotation @" + annotationClass.getName());
                }
            });
            this.methodInterceptor.enableMethodHandling(true);
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
        finally {
            this.methodInterceptor.enableMethodExecution(previousMethodExecution);
        }
    }

    private void invokeRuleMethod(Object rule, String methodName) throws Throwable {
        if (!this.executeLifeCycleMethods) {
            return;
        }
        Optional<Method> optionalMethod = ReflectionUtil.findMethodTransitively(rule.getClass(), methodName);
        if (!optionalMethod.isPresent()) {
            log.debug("Class {} has no {} method, but was used as ScenarioRule!", rule.getClass(), (Object)methodName);
            return;
        }
        try {
            ReflectionUtil.invokeMethod(rule, (Method)optionalMethod.get(), " of rule class " + rule.getClass().getName());
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
    }

    void executeBeforeStageSteps(Object stage) throws Throwable {
        this.executeAnnotatedMethods(stage, BeforeStage.class);
    }

    private void executeBeforeScenarioMethods(Object stage) throws Throwable {
        this.executeAnnotatedMethods(stage, BeforeScenario.class);
    }

    @Override
    public void readScenarioState(Object object) {
        this.injector.readValues(object);
    }

    @Override
    public void wireSteps(CanWire canWire) {
        for (StageState steps : this.stages.values()) {
            canWire.wire(steps.instance);
        }
    }

    @Override
    public void finished() throws Throwable {
        if (this.state == ScenarioExecutor.State.FINISHED) {
            return;
        }
        ScenarioExecutor.State previousState = this.state;
        this.state = ScenarioExecutor.State.FINISHED;
        this.methodInterceptor.enableMethodHandling(false);
        try {
            if (previousState == ScenarioExecutor.State.STARTED) {
                this.callFinishLifeCycleMethods();
            }
        }
        finally {
            this.listener.scenarioFinished();
        }
    }

    private void callFinishLifeCycleMethods() throws Throwable {
        Throwable firstThrownException = this.failedException;
        if (this.beforeScenarioMethodsExecuted) {
            try {
                if (this.currentTopLevelStage != null) {
                    this.executeAfterStageMethods(this.currentTopLevelStage);
                }
            }
            catch (AssertionError e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
            for (StageState stage : Lists.reverse((List)Lists.newArrayList(this.stages.values()))) {
                try {
                    this.executeAnnotatedMethods(stage.instance, AfterScenario.class);
                }
                catch (AssertionError e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
                }
                catch (Exception e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, e);
                }
            }
        }
        for (Object rule : Lists.reverse(this.scenarioRules)) {
            try {
                this.invokeRuleMethod(rule, "after");
            }
            catch (AssertionError e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
        }
        this.failedException = firstThrownException;
        if (!this.suppressExceptions && this.failedException != null) {
            throw this.failedException;
        }
        if (this.failIfPass && this.failedException == null) {
            throw new FailIfPassedException();
        }
    }

    private Throwable logAndGetFirstException(Throwable firstThrownException, Throwable newException) {
        log.error(newException.getMessage(), newException);
        return firstThrownException == null ? newException : firstThrownException;
    }

    @Override
    public void injectStages(Object stage) {
        for (Field field : FieldCache.get(stage.getClass()).getFieldsWithAnnotation(ScenarioStage.class)) {
            Object steps = this.addStage(field.getType());
            ReflectionUtil.setField(field, stage, steps, ", annotated with @ScenarioStage");
        }
    }

    @Override
    public boolean hasFailed() {
        return this.failedException != null;
    }

    @Override
    public Throwable getFailedException() {
        return this.failedException;
    }

    @Override
    public void setFailedException(Exception e) {
        this.failedException = e;
    }

    @Override
    public void failed(Throwable e) {
        if (this.hasFailed()) {
            log.error(e.getMessage(), e);
        } else {
            this.listener.scenarioFailed(e);
            this.methodInterceptor.disableMethodExecution();
            this.failedException = e;
        }
    }

    @Override
    public void startScenario(String description) {
        this.listener.scenarioStarted(description);
    }

    @Override
    public void startScenario(Class<?> testClass, Method method, List<NamedArgument> arguments) {
        this.listener.scenarioStarted(testClass, method, arguments);
        if (method.isAnnotationPresent(Pending.class)) {
            Pending annotation = method.getAnnotation(Pending.class);
            if (annotation.failIfPass()) {
                this.failIfPass();
            } else if (!annotation.executeSteps()) {
                this.methodInterceptor.disableMethodExecution();
                this.executeLifeCycleMethods = false;
            }
            this.suppressExceptions = true;
        } else if (method.isAnnotationPresent(NotImplementedYet.class)) {
            NotImplementedYet annotation = method.getAnnotation(NotImplementedYet.class);
            if (annotation.failIfPass()) {
                this.failIfPass();
            } else if (!annotation.executeSteps()) {
                this.methodInterceptor.disableMethodExecution();
                this.executeLifeCycleMethods = false;
            }
            this.suppressExceptions = true;
        }
    }

    @Override
    public void setListener(ScenarioListener listener) {
        this.listener = listener;
    }

    @Override
    public void failIfPass() {
        this.failIfPass = true;
    }

    @Override
    public void addSection(String sectionTitle) {
        this.listener.sectionAdded(sectionTitle);
    }

    class StageTransitionHandlerImpl
    implements StageTransitionHandler {
        StageTransitionHandlerImpl() {
        }

        @Override
        public void enterStage(Object parentStage, Object childStage) throws Throwable {
            StageState stageState;
            if (parentStage == childStage || StandaloneScenarioExecutor.this.currentTopLevelStage == childStage) {
                return;
            }
            if (StandaloneScenarioExecutor.this.currentTopLevelStage == null) {
                StandaloneScenarioExecutor.this.ensureBeforeScenarioMethodsAreExecuted();
            } else if (parentStage == null) {
                StandaloneScenarioExecutor.this.executeAfterStageMethods(StandaloneScenarioExecutor.this.currentTopLevelStage);
                StandaloneScenarioExecutor.this.readScenarioState(StandaloneScenarioExecutor.this.currentTopLevelStage);
            } else {
                StandaloneScenarioExecutor.this.readScenarioState(parentStage);
                stageState = StandaloneScenarioExecutor.this.getStageState(parentStage);
                if (stageState.currentChildStage != null && stageState.currentChildStage != childStage && !StandaloneScenarioExecutor.this.afterStageMethodsCalled(stageState.currentChildStage)) {
                    StandaloneScenarioExecutor.this.updateScenarioState(stageState.currentChildStage);
                    StandaloneScenarioExecutor.this.executeAfterStageMethods(stageState.currentChildStage);
                    StandaloneScenarioExecutor.this.readScenarioState(stageState.currentChildStage);
                }
                stageState.currentChildStage = childStage;
            }
            StandaloneScenarioExecutor.this.updateScenarioState(childStage);
            stageState = StandaloneScenarioExecutor.this.getStageState(childStage);
            if (!stageState.beforeStageCalled) {
                stageState.beforeStageCalled = true;
                StandaloneScenarioExecutor.this.executeBeforeStageSteps(childStage);
            }
            if (parentStage == null) {
                StandaloneScenarioExecutor.this.currentTopLevelStage = childStage;
            }
        }

        @Override
        public void leaveStage(Object parentStage, Object childStage) throws Throwable {
            if (parentStage == childStage || parentStage == null) {
                return;
            }
            StandaloneScenarioExecutor.this.readScenarioState(childStage);
            StageState childState = StandaloneScenarioExecutor.this.getStageState(childStage);
            if (childState.currentChildStage != null) {
                StandaloneScenarioExecutor.this.updateScenarioState(childState.currentChildStage);
                if (StandaloneScenarioExecutor.this.executeAfterStageMethods(childState.currentChildStage)) {
                    StandaloneScenarioExecutor.this.readScenarioState(childState.currentChildStage);
                    StandaloneScenarioExecutor.this.updateScenarioState(childStage);
                }
                childState.currentChildStage = null;
            }
            StandaloneScenarioExecutor.this.updateScenarioState(parentStage);
        }
    }

    class MethodHandler
    implements StepMethodHandler {
        MethodHandler() {
        }

        @Override
        public void handleMethod(Object stageInstance, Method paramMethod, Object[] arguments, InvocationMode mode, boolean hasNestedSteps) throws Throwable {
            List<NamedArgument> namedArguments = ParameterNameUtil.mapArgumentsWithParameterNames(paramMethod, Arrays.asList(arguments));
            StandaloneScenarioExecutor.this.listener.stepMethodInvoked(paramMethod, namedArguments, mode, hasNestedSteps);
        }

        @Override
        public void handleThrowable(Throwable t) throws Throwable {
            if (t.getClass().getName().equals("org.junit.AssumptionViolatedException")) {
                throw t;
            }
            StandaloneScenarioExecutor.this.listener.stepMethodFailed(t);
            StandaloneScenarioExecutor.this.failed(t);
        }

        @Override
        public void handleMethodFinished(long durationInNanos, boolean hasNestedSteps) {
            StandaloneScenarioExecutor.this.listener.stepMethodFinished(durationInNanos, hasNestedSteps);
        }
    }

    class ScenarioAccessImpl
    implements CurrentScenario {
        ScenarioAccessImpl() {
        }

        @Override
        public void addTag(Class<? extends Annotation> annotationClass, String ... values) {
            StandaloneScenarioExecutor.this.listener.tagAdded(annotationClass, values);
        }
    }

    class StepAccessImpl
    implements CurrentStep {
        StepAccessImpl() {
        }

        @Override
        public void addAttachment(Attachment attachment) {
            StandaloneScenarioExecutor.this.listener.attachmentAdded(attachment);
        }

        @Override
        public void setExtendedDescription(String extendedDescription) {
            StandaloneScenarioExecutor.this.listener.extendedDescriptionUpdated(extendedDescription);
        }
    }

    protected static class StageState {
        final Object instance;
        boolean afterStageCalled;
        boolean beforeStageCalled;
        public Object currentChildStage;

        StageState(Object instance) {
            this.instance = instance;
        }
    }
}

