/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.CurrentScenario;
import com.tngtech.jgiven.CurrentStep;
import com.tngtech.jgiven.annotation.AfterScenario;
import com.tngtech.jgiven.annotation.AfterStage;
import com.tngtech.jgiven.annotation.BeforeScenario;
import com.tngtech.jgiven.annotation.BeforeStage;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.annotation.ScenarioRule;
import com.tngtech.jgiven.annotation.ScenarioStage;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.exception.FailIfPassedException;
import com.tngtech.jgiven.exception.JGivenUserException;
import com.tngtech.jgiven.impl.ByteBuddyStageCreator;
import com.tngtech.jgiven.impl.StageCreator;
import com.tngtech.jgiven.impl.inject.ValueInjector;
import com.tngtech.jgiven.impl.intercept.NoOpScenarioListener;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.intercept.StageTransitionHandler;
import com.tngtech.jgiven.impl.intercept.StepInterceptorImpl;
import com.tngtech.jgiven.impl.util.FieldCache;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.integration.CanWire;
import com.tngtech.jgiven.report.model.NamedArgument;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScenarioExecutor.class);
    private Object currentTopLevelStage;
    private State state = State.INIT;
    private boolean beforeScenarioMethodsExecuted;
    private boolean executeLifeCycleMethods = true;
    protected final Map<Class<?>, StageState> stages = Maps.newLinkedHashMap();
    private final List<Object> scenarioRules = Lists.newArrayList();
    private final ValueInjector injector = new ValueInjector();
    private StageCreator stageCreator = new ByteBuddyStageCreator();
    private ScenarioListener listener = new NoOpScenarioListener();
    protected final StageTransitionHandler stageTransitionHandler = new StageTransitionHandlerImpl();
    protected final StepInterceptorImpl methodInterceptor = new StepInterceptorImpl(this, this.listener, this.stageTransitionHandler);
    private Throwable failedException;
    private boolean failIfPass;
    private boolean suppressExceptions;

    public ScenarioExecutor() {
        this.injector.injectValueByType(ScenarioExecutor.class, this);
        this.injector.injectValueByType(CurrentStep.class, new StepAccessImpl());
        this.injector.injectValueByType(CurrentScenario.class, new ScenarioAccessImpl());
    }

    public <T> T addStage(Class<T> stageClass) {
        if (this.stages.containsKey(stageClass)) {
            return (T)this.stages.get(stageClass).instance;
        }
        T result = this.stageCreator.createStage(stageClass, this.methodInterceptor);
        this.methodInterceptor.enableMethodInterception(true);
        this.stages.put(stageClass, new StageState(result));
        this.gatherRules(result);
        this.injectStages(result);
        return result;
    }

    public void addIntroWord(String word) {
        this.listener.introWordAdded(word);
    }

    private void gatherRules(Object stage) {
        for (Field field : FieldCache.get(stage.getClass()).getFieldsWithAnnotation(ScenarioRule.class)) {
            log.debug("Found rule in field {} ", (Object)field);
            try {
                this.scenarioRules.add(field.get(stage));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while reading field " + field, e);
            }
        }
    }

    private <T> void updateScenarioState(T t) {
        this.injector.updateValues(t);
    }

    private boolean afterStageMethodsCalled(Object stage) {
        return this.getStageState((Object)stage).afterStageCalled;
    }

    private boolean executeAfterStageMethods(Object stage) throws Throwable {
        StageState stageState = this.getStageState(stage);
        if (stageState.afterStageCalled) {
            return false;
        }
        stageState.afterStageCalled = true;
        this.executeAnnotatedMethods(stage, AfterStage.class);
        return true;
    }

    public StageState getStageState(Object stage) {
        StageState stageState = this.stages.get(stage.getClass());
        return stageState != null ? stageState : this.stages.get(stage.getClass().getSuperclass());
    }

    private void ensureBeforeScenarioMethodsAreExecuted() throws Throwable {
        if (this.state != State.INIT) {
            return;
        }
        this.state = State.STARTED;
        this.methodInterceptor.enableMethodInterception(false);
        try {
            for (Object rule : this.scenarioRules) {
                this.invokeRuleMethod(rule, "before");
            }
            this.beforeScenarioMethodsExecuted = true;
            for (StageState stage : this.stages.values()) {
                this.executeBeforeScenarioMethods(stage.instance);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            this.finished();
            throw e;
        }
        this.methodInterceptor.enableMethodInterception(true);
    }

    private void executeAnnotatedMethods(Object stage, final Class<? extends Annotation> annotationClass) throws Throwable {
        if (!this.executeLifeCycleMethods) {
            return;
        }
        log.debug("Executing methods annotated with @{}", (Object)annotationClass.getName());
        boolean previousMethodExecution = this.methodInterceptor.enableMethodExecution(true);
        try {
            this.methodInterceptor.enableMethodInterception(false);
            ReflectionUtil.forEachMethod(stage, stage.getClass(), annotationClass, new ReflectionUtil.MethodAction(){

                @Override
                public void act(Object object, Method method) throws Exception {
                    ReflectionUtil.invokeMethod(object, method, " with annotation @" + annotationClass.getName());
                }
            });
            this.methodInterceptor.enableMethodInterception(true);
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
        finally {
            this.methodInterceptor.enableMethodExecution(previousMethodExecution);
        }
    }

    private void invokeRuleMethod(Object rule, String methodName) throws Throwable {
        if (!this.executeLifeCycleMethods) {
            return;
        }
        Optional<Method> optionalMethod = ReflectionUtil.findMethodTransitively(rule.getClass(), methodName);
        if (!optionalMethod.isPresent()) {
            log.debug("Class {} has no {} method, but was used as ScenarioRule!", rule.getClass(), (Object)methodName);
            return;
        }
        try {
            ReflectionUtil.invokeMethod(rule, (Method)optionalMethod.get(), " of rule class " + rule.getClass().getName());
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
    }

    void executeBeforeStageSteps(Object stage) throws Throwable {
        this.executeAnnotatedMethods(stage, BeforeStage.class);
    }

    private void executeBeforeScenarioMethods(Object stage) throws Throwable {
        this.executeAnnotatedMethods(stage, BeforeScenario.class);
    }

    public void readScenarioState(Object object) {
        this.injector.readValues(object);
    }

    public void wireSteps(CanWire canWire) {
        for (StageState steps : this.stages.values()) {
            canWire.wire(steps.instance);
        }
    }

    public void finished() throws Throwable {
        if (this.state == State.FINISHED) {
            return;
        }
        State previousState = this.state;
        this.state = State.FINISHED;
        this.methodInterceptor.enableMethodInterception(false);
        try {
            if (previousState == State.STARTED) {
                this.callFinishLifeCycleMethods();
            }
        }
        finally {
            this.listener.scenarioFinished();
        }
    }

    private void callFinishLifeCycleMethods() throws Throwable {
        Throwable firstThrownException = this.failedException;
        if (this.beforeScenarioMethodsExecuted) {
            try {
                if (this.currentTopLevelStage != null) {
                    this.executeAfterStageMethods(this.currentTopLevelStage);
                }
            }
            catch (AssertionError e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
            for (StageState stage : Lists.reverse((List)Lists.newArrayList(this.stages.values()))) {
                try {
                    this.executeAnnotatedMethods(stage.instance, AfterScenario.class);
                }
                catch (AssertionError e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
                }
                catch (Exception e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, e);
                }
            }
        }
        for (Object rule : Lists.reverse(this.scenarioRules)) {
            try {
                this.invokeRuleMethod(rule, "after");
            }
            catch (AssertionError e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
        }
        this.failedException = firstThrownException;
        if (!this.suppressExceptions && this.failedException != null) {
            throw this.failedException;
        }
        if (this.failIfPass && this.failedException == null) {
            throw new FailIfPassedException();
        }
    }

    private Throwable logAndGetFirstException(Throwable firstThrownException, Throwable newException) {
        log.error(newException.getMessage(), newException);
        return firstThrownException == null ? newException : firstThrownException;
    }

    public void injectStages(Object stage) {
        for (Field field : FieldCache.get(stage.getClass()).getFieldsWithAnnotation(ScenarioStage.class)) {
            Object steps = this.addStage(field.getType());
            ReflectionUtil.setField(field, stage, steps, ", annotated with @ScenarioStage");
        }
    }

    public boolean hasFailed() {
        return this.failedException != null;
    }

    public Throwable getFailedException() {
        return this.failedException;
    }

    public void setFailedException(Exception e) {
        this.failedException = e;
    }

    public void failed(Throwable e) {
        if (this.hasFailed()) {
            log.error(e.getMessage(), e);
        } else {
            this.listener.scenarioFailed(e);
            this.methodInterceptor.disableMethodExecution();
            this.failedException = e;
        }
    }

    public void startScenario(String description) {
        this.listener.scenarioStarted(description);
    }

    public void startScenario(Class<?> testClass, Method method, List<NamedArgument> arguments) {
        this.listener.scenarioStarted(testClass, method, arguments);
        if (method.isAnnotationPresent(Pending.class)) {
            Pending annotation = method.getAnnotation(Pending.class);
            if (annotation.failIfPass()) {
                this.failIfPass();
            } else if (!annotation.executeSteps()) {
                this.methodInterceptor.disableMethodExecution();
                this.executeLifeCycleMethods = false;
            }
            this.suppressExceptions = true;
        } else if (method.isAnnotationPresent(NotImplementedYet.class)) {
            NotImplementedYet annotation = method.getAnnotation(NotImplementedYet.class);
            if (annotation.failIfPass()) {
                this.failIfPass();
            } else if (!annotation.executeSteps()) {
                this.methodInterceptor.disableMethodExecution();
                this.executeLifeCycleMethods = false;
            }
            this.suppressExceptions = true;
        }
    }

    public void setListener(ScenarioListener listener) {
        this.listener = listener;
        this.methodInterceptor.setScenarioListener(listener);
    }

    public void failIfPass() {
        this.failIfPass = true;
    }

    public void addSection(String sectionTitle) {
        this.listener.sectionAdded(sectionTitle);
    }

    public void setStageCreator(StageCreator stageCreator) {
        this.stageCreator = stageCreator;
    }

    class StageTransitionHandlerImpl
    implements StageTransitionHandler {
        StageTransitionHandlerImpl() {
        }

        @Override
        public void enterStage(Object parentStage, Object childStage) throws Throwable {
            StageState stageState;
            if (parentStage == childStage || ScenarioExecutor.this.currentTopLevelStage == childStage) {
                return;
            }
            if (ScenarioExecutor.this.currentTopLevelStage == null) {
                ScenarioExecutor.this.ensureBeforeScenarioMethodsAreExecuted();
            } else if (parentStage == null) {
                ScenarioExecutor.this.executeAfterStageMethods(ScenarioExecutor.this.currentTopLevelStage);
                ScenarioExecutor.this.readScenarioState(ScenarioExecutor.this.currentTopLevelStage);
            } else {
                ScenarioExecutor.this.readScenarioState(parentStage);
                stageState = ScenarioExecutor.this.getStageState(parentStage);
                if (stageState.currentChildStage != null && stageState.currentChildStage != childStage && !ScenarioExecutor.this.afterStageMethodsCalled(stageState.currentChildStage)) {
                    ScenarioExecutor.this.updateScenarioState(stageState.currentChildStage);
                    ScenarioExecutor.this.executeAfterStageMethods(stageState.currentChildStage);
                    ScenarioExecutor.this.readScenarioState(stageState.currentChildStage);
                }
                stageState.currentChildStage = childStage;
            }
            ScenarioExecutor.this.updateScenarioState(childStage);
            stageState = ScenarioExecutor.this.getStageState(childStage);
            if (!stageState.beforeStageCalled) {
                stageState.beforeStageCalled = true;
                ScenarioExecutor.this.executeBeforeStageSteps(childStage);
            }
            if (parentStage == null) {
                ScenarioExecutor.this.currentTopLevelStage = childStage;
            }
        }

        @Override
        public void leaveStage(Object parentStage, Object childStage) throws Throwable {
            if (parentStage == childStage || parentStage == null) {
                return;
            }
            ScenarioExecutor.this.readScenarioState(childStage);
            StageState childState = ScenarioExecutor.this.getStageState(childStage);
            if (childState.currentChildStage != null) {
                ScenarioExecutor.this.updateScenarioState(childState.currentChildStage);
                if (ScenarioExecutor.this.executeAfterStageMethods(childState.currentChildStage)) {
                    ScenarioExecutor.this.readScenarioState(childState.currentChildStage);
                    ScenarioExecutor.this.updateScenarioState(childStage);
                }
                childState.currentChildStage = null;
            }
            ScenarioExecutor.this.updateScenarioState(parentStage);
        }
    }

    class ScenarioAccessImpl
    implements CurrentScenario {
        ScenarioAccessImpl() {
        }

        @Override
        public void addTag(Class<? extends Annotation> annotationClass, String ... values) {
            ScenarioExecutor.this.listener.tagAdded(annotationClass, values);
        }
    }

    class StepAccessImpl
    implements CurrentStep {
        StepAccessImpl() {
        }

        @Override
        public void addAttachment(Attachment attachment) {
            ScenarioExecutor.this.listener.attachmentAdded(attachment);
        }

        @Override
        public void setExtendedDescription(String extendedDescription) {
            ScenarioExecutor.this.listener.extendedDescriptionUpdated(extendedDescription);
        }
    }

    protected static class StageState {
        final Object instance;
        boolean afterStageCalled;
        boolean beforeStageCalled;
        public Object currentChildStage;

        StageState(Object instance) {
            this.instance = instance;
        }
    }

    public static enum State {
        INIT,
        STARTED,
        FINISHED;

    }
}

