/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.format.table;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.config.FormatterConfiguration;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.format.table.RowFormatter;
import com.tngtech.jgiven.format.table.RowFormatterFactory;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FieldBasedRowFormatter
extends RowFormatter {
    private final Class<?> type;
    private final Table tableAnnotation;
    private final String parameterName;
    private final Annotation[] annotations;
    private List<Field> fields;
    boolean[] nonNullColumns;

    public FieldBasedRowFormatter(Class<?> type, String parameterName, Table tableAnnotation, Annotation[] annotations) {
        this.type = type;
        this.tableAnnotation = tableAnnotation;
        this.parameterName = parameterName;
        this.annotations = annotations;
        this.fields = FieldBasedRowFormatter.getFields(tableAnnotation, type);
        this.nonNullColumns = new boolean[this.fields.size()];
    }

    @Override
    public List<String> header() {
        return FieldBasedRowFormatter.getFieldNames(this.fields);
    }

    @Override
    public List<String> formatRow(Object object) {
        List<Object> allFieldValues = ReflectionUtil.getAllFieldValues(object, this.fields, "");
        for (int i = 0; i < allFieldValues.size(); ++i) {
            if (allFieldValues.get(i) == null) continue;
            this.nonNullColumns[i] = true;
        }
        return FieldBasedRowFormatter.toStringList(allFieldValues);
    }

    private static List<Field> getFields(Table tableAnnotation, Class<?> type) {
        final HashSet includeFields = Sets.newHashSet((Object[])tableAnnotation.includeFields());
        final HashSet excludeFields = Sets.newHashSet((Object[])tableAnnotation.excludeFields());
        return FluentIterable.from(ReflectionUtil.getAllNonStaticFields(type)).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                String name = input.getName();
                if (!includeFields.isEmpty()) {
                    return includeFields.contains(name);
                }
                return !excludeFields.contains(name);
            }
        }).toList();
    }

    private static List<String> getFieldNames(Iterable<Field> fields) {
        return FluentIterable.from(ReflectionUtil.getAllFieldNames(fields)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.replace('_', ' ');
            }
        }).toList();
    }

    private static List<String> toStringList(List<Object> values) {
        ArrayList list = Lists.newArrayList();
        for (Object v : values) {
            list.add(DefaultFormatter.INSTANCE.format(v));
        }
        return list;
    }

    @Override
    public List<List<String>> postProcess(List<List<String>> list) {
        if (!this.tableAnnotation.includeNullColumns()) {
            return this.removeNullColumns(list);
        }
        return list;
    }

    private List<List<String>> removeNullColumns(List<List<String>> list) {
        ArrayList newList = Lists.newArrayListWithCapacity((int)list.size());
        for (List<String> row : list) {
            ArrayList newRow = Lists.newArrayList();
            newList.add(newRow);
            for (int i = 0; i < this.nonNullColumns.length; ++i) {
                if (!this.nonNullColumns[i]) continue;
                newRow.add(row.get(i));
            }
        }
        return newList;
    }

    public static class Factory
    implements RowFormatterFactory {
        @Override
        public RowFormatter create(Class<?> parameterType, String parameterName, Table tableAnnotation, Annotation[] annotations, FormatterConfiguration configuration, ObjectFormatter<?> objectFormatter) {
            return new FieldBasedRowFormatter(parameterType, parameterName, tableAnnotation, annotations);
        }
    }
}

