/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.inject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.annotation.ExpectedScenarioState;
import com.tngtech.jgiven.annotation.ProvidedScenarioState;
import com.tngtech.jgiven.annotation.ScenarioState;
import com.tngtech.jgiven.exception.AmbiguousResolutionException;
import com.tngtech.jgiven.exception.JGivenMissingRequiredScenarioStateException;
import com.tngtech.jgiven.impl.inject.ScenarioStateField;
import com.tngtech.jgiven.impl.inject.ValueInjectorState;
import com.tngtech.jgiven.impl.util.FieldCache;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueInjector {
    private static final Logger log = LoggerFactory.getLogger(ValueInjector.class);
    private final ValueInjectorState state = new ValueInjectorState();
    private static final ConcurrentHashMap<Class<?>, Boolean> validatedClasses = new ConcurrentHashMap();

    public void validateFields(Object object) {
        if (validatedClasses.get(object.getClass()) == Boolean.TRUE) {
            return;
        }
        HashMap resolvedFields = Maps.newHashMap();
        for (ScenarioStateField field : this.getScenarioFields(object)) {
            field.getField().setAccessible(true);
            ScenarioState.Resolution resolution = field.getResolution();
            Object key = null;
            key = resolution == ScenarioState.Resolution.NAME ? field.getField().getName() : field.getField().getType();
            if (resolvedFields.containsKey(key)) {
                Field existingField = (Field)resolvedFields.get(key);
                throw new AmbiguousResolutionException("Ambiguous fields with same " + (Object)((Object)resolution) + " detected. Field 1: " + existingField + ", field 2: " + field.getField());
            }
            resolvedFields.put(key, field.getField());
        }
        validatedClasses.put(object.getClass(), Boolean.TRUE);
    }

    private List<ScenarioStateField> getScenarioFields(Object object) {
        List<Field> scenarioFields = FieldCache.get(object.getClass()).getFieldsWithAnnotation(ScenarioState.class, ProvidedScenarioState.class, ExpectedScenarioState.class);
        return Lists.transform(scenarioFields, ScenarioStateField.fromField);
    }

    public void readValues(Object object) {
        this.validateFields(object);
        for (ScenarioStateField field : this.getScenarioFields(object)) {
            try {
                Object value = field.getField().get(object);
                this.updateValue(field, value);
                log.debug("Reading value {} from field {}", value, (Object)field.getField());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while reading field " + field.getField(), e);
            }
        }
    }

    public void updateValues(Object object) {
        this.validateFields(object);
        for (ScenarioStateField field : this.getScenarioFields(object)) {
            Object value = this.getValue(field);
            if (value != null) {
                try {
                    field.getField().set(object, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error while updating field " + field.getField(), e);
                }
                log.debug("Setting field {} to value {}", (Object)field.getField(), value);
                continue;
            }
            if (!field.isRequired()) continue;
            throw new JGivenMissingRequiredScenarioStateException(field.getField());
        }
    }

    public <T> void injectValueByType(Class<T> clazz, T value) {
        this.state.updateValueByType(clazz, value);
    }

    public <T> void injectValueByName(String name, T value) {
        this.state.updateValueByName(name, value);
    }

    private void updateValue(ScenarioStateField field, Object value) {
        if (field.getResolution() == ScenarioState.Resolution.NAME) {
            this.state.updateValueByName(field.getField().getName(), value);
        } else {
            this.state.updateValueByType(field.getField().getType(), value);
        }
    }

    private Object getValue(ScenarioStateField field) {
        if (field.getResolution() == ScenarioState.Resolution.NAME) {
            return this.state.getValueByName(field.getField().getName());
        }
        return this.state.getValueByType(field.getField().getType());
    }
}

