/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.As;
import com.tngtech.jgiven.annotation.AsProvider;
import com.tngtech.jgiven.annotation.CaseAs;
import com.tngtech.jgiven.annotation.CaseAsProvider;
import com.tngtech.jgiven.annotation.Description;
import com.tngtech.jgiven.annotation.ExtendedDescription;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.IntroWord;
import com.tngtech.jgiven.annotation.IsTag;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.annotation.StepComment;
import com.tngtech.jgiven.attachment.Attachment;
import com.tngtech.jgiven.config.AbstractJGivenConfiguration;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.config.TagConfiguration;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.impl.format.ParameterFormattingUtil;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.params.DefaultAsProvider;
import com.tngtech.jgiven.impl.util.AnnotationUtil;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.InvocationMode;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepFormatter;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Tag;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioModelBuilder
implements ScenarioListener {
    private static final Logger log = LoggerFactory.getLogger(ScenarioModelBuilder.class);
    private static final Set<String> STACK_TRACE_FILTER = ImmutableSet.of((Object)"sun.reflect", (Object)"com.tngtech.jgiven.impl.intercept", (Object)"com.tngtech.jgiven.impl.intercept", (Object)"$$EnhancerByCGLIB$$", (Object)"java.lang.reflect", (Object)"net.sf.cglib.proxy", (Object[])new String[]{"com.sun.proxy"});
    private static final boolean FILTER_STACK_TRACE = Config.config().filterStackTrace();
    private ScenarioModel scenarioModel;
    private ScenarioCaseModel scenarioCaseModel;
    private StepModel currentStep;
    private final Stack<StepModel> parentSteps = new Stack();
    private List<StepModel> nestedSteps;
    private Word introWord;
    private long scenarioStartedNanos;
    private AbstractJGivenConfiguration configuration = new DefaultConfiguration();
    private ReportModel reportModel;

    public void setReportModel(ReportModel reportModel) {
        this.reportModel = reportModel;
    }

    @Override
    public void scenarioStarted(String description) {
        this.scenarioStartedNanos = System.nanoTime();
        String readableDescription = description;
        if (description.contains("_")) {
            readableDescription = description.replace('_', ' ');
        } else if (!description.contains(" ")) {
            readableDescription = WordUtil.camelCaseToCapitalizedReadableText(description);
        }
        this.scenarioCaseModel = new ScenarioCaseModel();
        this.scenarioModel = new ScenarioModel();
        this.scenarioModel.addCase(this.scenarioCaseModel);
        this.scenarioModel.setDescription(readableDescription);
    }

    public void addStepMethod(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode, boolean hasNestedSteps) {
        StepModel stepModel = this.createStepModel(paramMethod, arguments, mode);
        if (this.parentSteps.empty()) {
            this.getCurrentScenarioCase().addStep(stepModel);
        } else {
            this.parentSteps.peek().addNestedStep(stepModel);
        }
        if (hasNestedSteps) {
            this.parentSteps.push(stepModel);
        }
        this.currentStep = stepModel;
    }

    StepModel createStepModel(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode) {
        StepModel stepModel = new StepModel();
        stepModel.setName(this.getDescription(paramMethod));
        ExtendedDescription extendedDescriptionAnnotation = paramMethod.getAnnotation(ExtendedDescription.class);
        if (extendedDescriptionAnnotation != null) {
            stepModel.setExtendedDescription(extendedDescriptionAnnotation.value());
        }
        List<NamedArgument> nonHiddenArguments = this.filterHiddenArguments(arguments, paramMethod.getParameterAnnotations());
        ParameterFormattingUtil parameterFormattingUtil = new ParameterFormattingUtil(this.configuration);
        List<ObjectFormatter<?>> formatters = parameterFormattingUtil.getFormatter(paramMethod.getParameterTypes(), this.getNames(arguments), paramMethod.getParameterAnnotations());
        stepModel.setWords(new StepFormatter(stepModel.getName(), nonHiddenArguments, formatters).buildFormattedWords());
        if (this.introWord != null) {
            stepModel.addIntroWord(this.introWord);
            this.introWord = null;
        }
        stepModel.setStatus(mode.toStepStatus());
        return stepModel;
    }

    private List<NamedArgument> filterHiddenArguments(List<NamedArgument> arguments, Annotation[][] parameterAnnotations) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (AnnotationUtil.isHidden(parameterAnnotations[i])) continue;
            result.add(arguments.get(i));
        }
        return result;
    }

    @Override
    public void introWordAdded(String value) {
        this.introWord = new Word();
        this.introWord.setIntroWord(true);
        this.introWord.setValue(value);
    }

    @Override
    public void stepCommentAdded(List<NamedArgument> arguments) {
        if (arguments == null || arguments.size() != 1) {
            throw new JGivenWrongUsageException("A step comment method must have exactly one parameter.");
        }
        if (!(arguments.get(0).getValue() instanceof String)) {
            throw new JGivenWrongUsageException("The step comment method parameter must be a string.");
        }
        if (this.currentStep == null) {
            throw new JGivenWrongUsageException("A step comment must be added after the corresponding step, but no step has been executed yet.");
        }
        this.currentStep.setComment((String)arguments.get(0).getValue());
    }

    private ScenarioCaseModel getCurrentScenarioCase() {
        if (this.scenarioCaseModel == null) {
            this.scenarioStarted("A Scenario");
        }
        return this.scenarioCaseModel;
    }

    @Override
    public void stepMethodInvoked(Method method, List<NamedArgument> arguments, InvocationMode mode, boolean hasNestedSteps) {
        if (method.isAnnotationPresent(IntroWord.class)) {
            this.introWordAdded(this.getDescription(method));
        } else if (method.isAnnotationPresent(StepComment.class)) {
            this.stepCommentAdded(arguments);
        } else {
            this.addTags(method.getAnnotations());
            this.addTags(method.getDeclaringClass().getAnnotations());
            this.addStepMethod(method, arguments, mode, hasNestedSteps);
        }
    }

    public void setMethodName(String methodName) {
        this.scenarioModel.setTestMethodName(methodName);
    }

    public void setArguments(List<String> arguments) {
        this.scenarioCaseModel.setExplicitArguments(arguments);
    }

    public void setParameterNames(List<String> parameterNames) {
        this.scenarioModel.setExplicitParameters(ScenarioModelBuilder.removeUnderlines(parameterNames));
    }

    private static List<String> removeUnderlines(List<String> parameterNames) {
        ArrayList result = Lists.newArrayListWithCapacity((int)parameterNames.size());
        for (String paramName : parameterNames) {
            result.add(WordUtil.fromSnakeCase(paramName));
        }
        return result;
    }

    private String getDescription(Method paramMethod) {
        if (paramMethod.isAnnotationPresent(Hidden.class)) {
            return "";
        }
        Description description = paramMethod.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        As as = paramMethod.getAnnotation(As.class);
        AsProvider provider = as != null ? ReflectionUtil.newInstance(as.provider()) : new DefaultAsProvider();
        return provider.as(as, paramMethod);
    }

    @Deprecated
    public void setSuccess(boolean success) {
        this.scenarioCaseModel.setSuccess(success);
    }

    public void setStatus(ExecutionStatus status) {
        this.scenarioCaseModel.setStatus(status);
    }

    public void setException(Throwable throwable) {
        this.scenarioCaseModel.setErrorMessage(throwable.getClass().getName() + ": " + throwable.getMessage());
        this.scenarioCaseModel.setStackTrace(this.getStackTrace(throwable, FILTER_STACK_TRACE));
    }

    private List<String> getStackTrace(Throwable exception, boolean filterStackTrace) {
        StackTraceElement[] stackTraceElements = exception.getStackTrace();
        ArrayList<String> stackTrace = new ArrayList<String>(stackTraceElements.length);
        block0: for (StackTraceElement element : stackTraceElements) {
            if (filterStackTrace) {
                for (String filter : STACK_TRACE_FILTER) {
                    if (!element.getClassName().contains(filter)) continue;
                    continue block0;
                }
            }
            stackTrace.add(element.toString());
        }
        return stackTrace;
    }

    @Override
    public void stepMethodFailed(Throwable t) {
        if (this.currentStep != null) {
            this.currentStep.setStatus(StepStatus.FAILED);
        }
    }

    @Override
    public void stepMethodFinished(long durationInNanos, boolean hasNestedSteps) {
        if (hasNestedSteps && !this.parentSteps.isEmpty()) {
            this.currentStep = this.parentSteps.peek();
        }
        if (this.currentStep != null) {
            this.currentStep.setDurationInNanos(durationInNanos);
            if (hasNestedSteps) {
                if (this.currentStep.getStatus() != StepStatus.FAILED) {
                    this.currentStep.setStatus(this.getStatusFromNestedSteps(this.currentStep.getNestedSteps()));
                }
                this.parentSteps.pop();
            }
        }
        if (!hasNestedSteps && !this.parentSteps.isEmpty()) {
            this.currentStep = this.parentSteps.peek();
        }
    }

    private StepStatus getStatusFromNestedSteps(List<StepModel> nestedSteps) {
        StepStatus status = StepStatus.PASSED;
        for (StepModel nestedModel : nestedSteps) {
            StepStatus nestedStatus = nestedModel.getStatus();
            switch (nestedStatus) {
                case FAILED: {
                    return StepStatus.FAILED;
                }
                case PENDING: {
                    status = StepStatus.PENDING;
                }
            }
        }
        return status;
    }

    @Override
    public void scenarioFailed(Throwable e) {
        this.setSuccess(false);
        this.setStatus(ExecutionStatus.FAILED);
        this.setException(e);
    }

    @Override
    public void scenarioStarted(Class<?> testClass, Method method, List<NamedArgument> namedArguments) {
        this.readConfiguration(testClass);
        this.readAnnotations(testClass, method);
        this.scenarioModel.setClassName(testClass.getName());
        this.setParameterNames(this.getNames(namedArguments));
        this.setMethodName(method.getName());
        ParameterFormattingUtil parameterFormattingUtil = new ParameterFormattingUtil(this.configuration);
        List<ObjectFormatter<?>> formatter = parameterFormattingUtil.getFormatter(method.getParameterTypes(), this.getNames(namedArguments), method.getParameterAnnotations());
        this.setArguments(parameterFormattingUtil.toStringList(formatter, this.getValues(namedArguments)));
        this.setCaseDescription(testClass, method, namedArguments);
    }

    private void setCaseDescription(Class<?> testClass, Method method, List<NamedArgument> namedArguments) {
        CaseAs annotation = null;
        if (method.isAnnotationPresent(CaseAs.class)) {
            annotation = method.getAnnotation(CaseAs.class);
        } else if (testClass.isAnnotationPresent(CaseAs.class)) {
            annotation = testClass.getAnnotation(CaseAs.class);
        }
        if (annotation != null) {
            CaseAsProvider caseDescriptionProvider = ReflectionUtil.newInstance(annotation.provider());
            String value = annotation.value();
            List<Object> values = annotation.formatValues() ? this.scenarioCaseModel.getExplicitArguments() : this.getValues(namedArguments);
            String caseDescription = caseDescriptionProvider.as(value, this.scenarioModel.getExplicitParameters(), values);
            this.scenarioCaseModel.setDescription(caseDescription);
        }
    }

    private List<Object> getValues(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.value);
        }
        return result;
    }

    private List<String> getNames(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.name);
        }
        return result;
    }

    private void readConfiguration(Class<?> testClass) {
        this.configuration = ConfigurationUtil.getConfiguration(testClass);
    }

    private void readAnnotations(Class<?> testClass, Method method) {
        String scenarioDescription = method.getName();
        if (method.isAnnotationPresent(Description.class)) {
            scenarioDescription = method.getAnnotation(Description.class).value();
        } else if (method.isAnnotationPresent(As.class)) {
            As as = method.getAnnotation(As.class);
            AsProvider provider = ReflectionUtil.newInstance(as.provider());
            scenarioDescription = provider.as(as, method);
        }
        this.scenarioStarted(scenarioDescription);
        if (method.isAnnotationPresent(ExtendedDescription.class)) {
            this.scenarioModel.setExtendedDescription(method.getAnnotation(ExtendedDescription.class).value());
        }
        if (method.isAnnotationPresent(NotImplementedYet.class) || method.isAnnotationPresent(Pending.class)) {
            this.scenarioCaseModel.setStatus(ExecutionStatus.SCENARIO_PENDING);
        }
        if (this.scenarioCaseModel.getCaseNr() == 1) {
            this.addTags(testClass.getAnnotations());
            this.addTags(method.getAnnotations());
        }
    }

    public void addTags(Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            this.addTags(this.toTags(annotation));
        }
    }

    private void addTags(List<Tag> tags) {
        if (tags.isEmpty()) {
            return;
        }
        if (this.reportModel != null) {
            this.reportModel.addTags(tags);
        }
        if (this.scenarioModel != null) {
            this.scenarioModel.addTags(tags);
        }
    }

    public List<Tag> toTags(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        TagConfiguration tagConfig = this.toTagConfiguration(annotationType);
        if (tagConfig == null) {
            return Collections.emptyList();
        }
        return this.toTags(tagConfig, (Optional<Annotation>)Optional.of((Object)annotation));
    }

    private List<Tag> toTags(TagConfiguration tagConfig, Optional<Annotation> annotation) {
        Tag tag = new Tag(tagConfig.getAnnotationFullType());
        tag.setType(tagConfig.getAnnotationType());
        if (!Strings.isNullOrEmpty((String)tagConfig.getName())) {
            tag.setName(tagConfig.getName());
        }
        if (tagConfig.isPrependType()) {
            tag.setPrependType(true);
        }
        tag.setShowInNavigation(tagConfig.showInNavigation());
        if (!Strings.isNullOrEmpty((String)tagConfig.getCssClass())) {
            tag.setCssClass(tagConfig.getCssClass());
        }
        if (!Strings.isNullOrEmpty((String)tagConfig.getColor())) {
            tag.setColor(tagConfig.getColor());
        }
        if (!Strings.isNullOrEmpty((String)tagConfig.getStyle())) {
            tag.setStyle(tagConfig.getStyle());
        }
        Object value = tagConfig.getDefaultValue();
        if (!Strings.isNullOrEmpty((String)tagConfig.getDefaultValue())) {
            tag.setValue(tagConfig.getDefaultValue());
        }
        tag.setTags(tagConfig.getTags());
        if (tagConfig.isIgnoreValue() || !annotation.isPresent()) {
            tag.setDescription(this.getDescriptionFromGenerator(tagConfig, (Annotation)annotation.orNull(), tagConfig.getDefaultValue()));
            tag.setHref(this.getHref(tagConfig, (Annotation)annotation.orNull(), value));
            return Arrays.asList(tag);
        }
        try {
            Method method = ((Annotation)annotation.get()).annotationType().getMethod("value", new Class[0]);
            value = method.invoke(annotation.get(), new Object[0]);
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] objectArray = (Object[])value;
                    if (tagConfig.isExplodeArray()) {
                        List<Tag> explodedTags = this.getExplodedTags(tag, objectArray, (Annotation)annotation.get(), tagConfig);
                        return explodedTags;
                    }
                    tag.setValue(this.toStringList(objectArray));
                } else {
                    tag.setValue(String.valueOf(value));
                }
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            log.error("Error while getting 'value' method of annotation " + annotation.get(), (Throwable)e);
        }
        tag.setDescription(this.getDescriptionFromGenerator(tagConfig, (Annotation)annotation.get(), value));
        tag.setHref(this.getHref(tagConfig, (Annotation)annotation.get(), value));
        return Arrays.asList(tag);
    }

    private TagConfiguration toTagConfiguration(Class<? extends Annotation> annotationType) {
        IsTag isTag = annotationType.getAnnotation(IsTag.class);
        if (isTag != null) {
            return this.fromIsTag(isTag, annotationType);
        }
        return this.configuration.getTagConfiguration(annotationType);
    }

    public TagConfiguration fromIsTag(IsTag isTag, Class<? extends Annotation> annotationType) {
        String name = Strings.isNullOrEmpty((String)isTag.name()) ? isTag.type() : isTag.name();
        return TagConfiguration.builder(annotationType).defaultValue(isTag.value()).description(isTag.description()).explodeArray(isTag.explodeArray()).ignoreValue(isTag.ignoreValue()).prependType(isTag.prependType()).name(name).descriptionGenerator(isTag.descriptionGenerator()).cssClass(isTag.cssClass()).color(isTag.color()).style(isTag.style()).tags(this.getTagNames(isTag, annotationType)).href(isTag.href()).hrefGenerator(isTag.hrefGenerator()).showInNavigation(isTag.showInNavigation()).build();
    }

    private List<String> getTagNames(IsTag isTag, Class<? extends Annotation> annotationType) {
        List<Tag> tags = this.getTags(isTag, annotationType);
        this.reportModel.addTags(tags);
        ArrayList tagNames = Lists.newArrayList();
        for (Tag tag : tags) {
            tagNames.add(tag.toIdString());
        }
        return tagNames;
    }

    private List<Tag> getTags(IsTag isTag, Class<? extends Annotation> annotationType) {
        ArrayList allTags = Lists.newArrayList();
        for (Annotation a : annotationType.getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(IsTag.class)) continue;
            List<Tag> tags = this.toTags(a);
            for (Tag tag : tags) {
                allTags.add(tag);
            }
        }
        return allTags;
    }

    private List<String> toStringList(Object[] value) {
        Object[] array = value;
        ArrayList values = Lists.newArrayList();
        for (Object v : array) {
            values.add(String.valueOf(v));
        }
        return values;
    }

    private String getDescriptionFromGenerator(TagConfiguration tagConfiguration, Annotation annotation, Object value) {
        try {
            return tagConfiguration.getDescriptionGenerator().newInstance().generateDescription(tagConfiguration, annotation, value);
        }
        catch (Exception e) {
            throw new JGivenWrongUsageException("Error while trying to generate the description for annotation " + annotation + " using DescriptionGenerator class " + tagConfiguration.getDescriptionGenerator() + ": " + e.getMessage(), e);
        }
    }

    private String getHref(TagConfiguration tagConfiguration, Annotation annotation, Object value) {
        try {
            return tagConfiguration.getHrefGenerator().newInstance().generateHref(tagConfiguration, annotation, value);
        }
        catch (Exception e) {
            throw new JGivenWrongUsageException("Error while trying to generate the href for annotation " + annotation + " using HrefGenerator class " + tagConfiguration.getHrefGenerator() + ": " + e.getMessage(), e);
        }
    }

    private List<Tag> getExplodedTags(Tag originalTag, Object[] values, Annotation annotation, TagConfiguration tagConfig) {
        ArrayList result = Lists.newArrayList();
        for (Object singleValue : values) {
            Tag newTag = originalTag.copy();
            newTag.setValue(String.valueOf(singleValue));
            newTag.setDescription(this.getDescriptionFromGenerator(tagConfig, annotation, singleValue));
            newTag.setHref(this.getHref(tagConfig, annotation, singleValue));
            result.add(newTag);
        }
        return result;
    }

    @Override
    public void scenarioFinished() {
        AssertionUtil.assertTrue(this.scenarioStartedNanos > 0L, "Scenario has no start time");
        long durationInNanos = System.nanoTime() - this.scenarioStartedNanos;
        this.scenarioCaseModel.setDurationInNanos(durationInNanos);
        this.scenarioModel.addDurationInNanos(durationInNanos);
        this.reportModel.addScenarioModelOrMergeWithExistingOne(this.scenarioModel);
    }

    @Override
    public void attachmentAdded(Attachment attachment) {
        this.currentStep.setAttachment(attachment);
    }

    @Override
    public void extendedDescriptionUpdated(String extendedDescription) {
        this.currentStep.setExtendedDescription(extendedDescription);
    }

    @Override
    public void sectionAdded(String sectionTitle) {
        StepModel stepModel = new StepModel();
        stepModel.setName(sectionTitle);
        stepModel.addWords(new Word(sectionTitle));
        stepModel.setIsSectionTitle(true);
        this.getCurrentScenarioCase().addStep(stepModel);
    }

    @Override
    public void tagAdded(Class<? extends Annotation> annotationClass, String ... values) {
        TagConfiguration tagConfig = this.toTagConfiguration(annotationClass);
        if (tagConfig == null) {
            return;
        }
        List<Tag> tags = this.toTags(tagConfig, (Optional<Annotation>)Optional.absent());
        if (tags.isEmpty()) {
            return;
        }
        if (values.length > 0) {
            this.addTags(this.getExplodedTags((Tag)Iterables.getOnlyElement(tags), values, null, tagConfig));
        } else {
            this.addTags(tags);
        }
    }

    public ReportModel getReportModel() {
        return this.reportModel;
    }

    public ScenarioModel getScenarioModel() {
        return this.scenarioModel;
    }

    public ScenarioCaseModel getScenarioCaseModel() {
        return this.scenarioCaseModel;
    }
}

