/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report;

import com.tngtech.jgiven.report.AbstractReportConfig;
import com.tngtech.jgiven.report.model.CompleteReportModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractReportGenerator.class);
    protected CompleteReportModel completeReportModel;
    public AbstractReportConfig config;

    public void setConfig(AbstractReportConfig config) {
        this.config = config;
    }

    protected void generateFromCommandLine(String ... args) {
        this.setConfig(this.createReportConfig(args));
        this.generateReport();
    }

    public void generateWithConfig(AbstractReportConfig config) {
        this.setConfig(config);
        this.generateReport();
    }

    public void generateReport() {
        this.loadReportModel();
        try {
            this.generate();
        }
        catch (Exception e) {
            System.err.println("Error: JGivenReport has encountered the following exception: " + e + "\n");
            this.printUsageAndExit();
        }
    }

    private void printUsageAndExit() {
        this.config.printUsageAndExit();
    }

    public void loadReportModel() {
        this.completeReportModel = this.config.getReportModel();
    }

    public abstract AbstractReportConfig createReportConfig(String ... var1);

    public abstract void generate() throws Exception;
}

