/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.config;

import com.tngtech.jgiven.annotation.IsTag;

public class TagConfiguration {
    boolean ignoreValue;
    boolean explodeArray = true;
    boolean prependType = false;
    String defaultValue = "";
    String description = "";
    String type = "";

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isExplodeArray() {
        return this.explodeArray;
    }

    public boolean isIgnoreValue() {
        return this.ignoreValue;
    }

    public boolean isPrependType() {
        return this.prependType;
    }

    public static TagConfiguration fromIsTag(IsTag isTag) {
        TagConfiguration result = new TagConfiguration();
        result.defaultValue = isTag.value();
        result.description = isTag.description();
        result.explodeArray = isTag.explodeArray();
        result.ignoreValue = isTag.ignoreValue();
        result.prependType = isTag.prependType();
        result.type = isTag.type();
        return result;
    }

    public static class Builder {
        final TagConfiguration configuration;

        Builder(TagConfiguration configuration) {
            this.configuration = configuration;
        }

        public Builder ignoreValue(boolean b) {
            this.configuration.ignoreValue = b;
            return this;
        }

        public Builder explodeArray(boolean b) {
            this.configuration.explodeArray = b;
            return this;
        }

        public Builder defaultValue(String s) {
            this.configuration.defaultValue = s;
            return this;
        }

        public Builder description(String s) {
            this.configuration.description = s;
            return this;
        }

        public Builder type(String s) {
            this.configuration.type = s;
            return this;
        }

        public Builder prependType(boolean b) {
            this.configuration.prependType = b;
            return this;
        }
    }
}

