/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.html.StaticHtmlReportGenerator;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.Tag;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class HtmlTocWriter {
    protected PrintWriter writer;
    private final Map<Tag, List<ScenarioModel>> tagMap;
    private final List<StaticHtmlReportGenerator.ModelFile> models;

    public HtmlTocWriter(Map<Tag, List<ScenarioModel>> tagMap, List<StaticHtmlReportGenerator.ModelFile> models) {
        this.tagMap = tagMap;
        this.models = models;
    }

    public void writeToc(PrintWriter writer) {
        this.writer = writer;
        writer.println("<div id='col-container'>");
        writer.println("<div id='leftpane'>");
        writer.println("<div id='toc'>");
        this.writeClassLinks();
        this.writeTagLinks();
        writer.println("</div> <!-- toc -->");
        writer.println("</div> <!-- leftpane -->");
    }

    private void writeClassLinks() {
        Comparator<StaticHtmlReportGenerator.ModelFile> comparator = new Comparator<StaticHtmlReportGenerator.ModelFile>(){

            @Override
            public int compare(StaticHtmlReportGenerator.ModelFile o1, StaticHtmlReportGenerator.ModelFile o2) {
                return o1.model.getSimpleClassName().compareTo(o2.model.getSimpleClassName());
            }
        };
        ArrayList sortedModels = Lists.newArrayList(this.models);
        Collections.sort(sortedModels, comparator);
        this.writer.println("<h3>Test Classes</h3>");
        this.writer.println("<ul>");
        for (StaticHtmlReportGenerator.ModelFile modelFile : sortedModels) {
            this.writeClassLink(modelFile);
        }
        this.writer.println("</ul>");
    }

    private void writeClassLink(StaticHtmlReportGenerator.ModelFile model) {
        this.writer.println(String.format("<li><a href='%s' >%s</a>", model.file.getName(), model.model.getSimpleClassName()));
    }

    private void writeTagLinks() {
        if (this.tagMap.isEmpty()) {
            return;
        }
        List<Tag> sortedTags = this.getSortedTags();
        this.writer.println("<h3>Tags</h3>");
        this.writer.println("<ul>");
        for (Tag tag : sortedTags) {
            this.writeTagLink(tag, this.tagMap.get(tag));
        }
        this.writer.println("</ul>");
    }

    public List<Tag> getSortedTags() {
        ArrayList sortedTags = Lists.newArrayList(this.tagMap.keySet());
        Collections.sort(sortedTags, new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return sortedTags;
    }

    private void writeTagLink(Tag tag, List<ScenarioModel> list) {
        this.writer.println(String.format("<li><a href='%s'>%s</a>", HtmlTocWriter.tagToFilename(tag), tag.toString()));
    }

    static String tagToFilename(Tag tag) {
        String fileName = HtmlTocWriter.escape(tag.getName());
        if (tag.getValue() != null) {
            fileName = tag.getValue().getClass().isArray() ? fileName + "-" + HtmlTocWriter.escape(Joiner.on((char)'-').join((Object[])((String[])tag.getValue()))) : fileName + "-" + HtmlTocWriter.escape((String)tag.getValue());
        }
        return fileName.substring(0, Math.min(fileName.length(), 255)) + ".html";
    }

    static String escape(String string) {
        return string.replaceAll("[^\\p{Alnum}-]", "_");
    }
}

