/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.html.DataTableScenarioHtmlWriter;
import com.tngtech.jgiven.report.html.HtmlTocWriter;
import com.tngtech.jgiven.report.html.HtmlWriterUtils;
import com.tngtech.jgiven.report.html.MultiCaseScenarioHtmlWriter;
import com.tngtech.jgiven.report.html.ScenarioHtmlWriter;
import com.tngtech.jgiven.report.impl.CommonReportHelper;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ReportStatistics;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StatisticsCalculator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class HtmlWriter
extends ReportModelVisitor {
    protected final PrintWriter writer;
    protected final HtmlWriterUtils utils;

    public HtmlWriter(PrintWriter writer) {
        this.writer = writer;
        this.utils = new HtmlWriterUtils(writer);
    }

    public void writeHtmlHeader(String title) {
        this.utils.writeHtmlHeader(title);
        this.writer.write("<div id='page'>");
    }

    public void writeHtmlFooter() {
        this.writer.println("</div> <!-- col-container -->");
        this.writer.println("<div id='page-footer'></div>");
        this.writer.println("</div> <!-- page -->");
        this.writeJGivenFooter();
        this.writer.println("<script src='report.js'></script>");
        this.writer.println("</body></html>");
    }

    private void writeJGivenFooter() {
        this.writer.print("<div id='footer'>Generated by <a href='http://github.com/TNG/JGiven'>JGiven</a> - on ");
        this.writer.print(DateFormat.getDateTimeInstance().format(new Date()));
        this.closeDiv();
    }

    private void closeDiv() {
        this.writer.println("</div>");
    }

    public void write(ScenarioModel model) {
        this.writeHtmlHeader(model.className);
        model.accept(this);
        this.writeHtmlFooter();
    }

    public void write(ReportModel model, HtmlTocWriter htmlTocWriter) {
        this.writeHtmlHeader(model.getClassName());
        if (htmlTocWriter != null) {
            htmlTocWriter.writeToc(this.writer);
        }
        model.accept(this);
        this.writeHtmlFooter();
    }

    private void writeStatistics(ReportModel model) {
        if (!model.getScenarios().isEmpty()) {
            ReportStatistics statistics = new StatisticsCalculator().getStatistics(model);
            this.writer.print("<div class='statistics'>");
            this.writer.print(statistics.numScenarios + " scenarios, " + statistics.numCases + " cases, " + statistics.numSteps + " steps, " + statistics.numFailedCases + " failed cases ");
            this.utils.writeDuration(statistics.durationInNanos);
            this.closeDiv();
        }
    }

    public static String toString(final ScenarioModel model) {
        return HtmlWriter.toString(new Function<PrintWriter, Void>(){

            public Void apply(PrintWriter input) {
                new HtmlWriter(input).write(model);
                return null;
            }
        });
    }

    public static String toString(final ReportModel model) {
        return HtmlWriter.toString(new Function<PrintWriter, Void>(){

            public Void apply(PrintWriter input) {
                new HtmlWriter(input).write(model, null);
                return null;
            }
        });
    }

    public static String toString(Function<PrintWriter, Void> writeFunction) {
        String string;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8.name()), false);
            writeFunction.apply((Object)printWriter);
            printWriter.flush();
            string = stream.toString(Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                ResourceUtil.close(printWriter);
                throw throwable;
            }
        }
        ResourceUtil.close(printWriter);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, ReportModel model, HtmlTocWriter htmlTocWriter) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter printWriter = new PrintWriter(file, Charsets.UTF_8.name());
        try {
            new HtmlWriter(printWriter).write(model, htmlTocWriter);
            printWriter.flush();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }

    @Override
    public void visit(ReportModel reportModel) {
        this.writer.println("<div id='rightpane'>");
        this.writeHeader(reportModel);
        this.writer.println("<div id='content'>");
    }

    void writeHeader(ReportModel reportModel) {
        this.writer.println("<div id='header'>");
        String packageName = "";
        String className = reportModel.getClassName();
        if (reportModel.getClassName().contains(".")) {
            packageName = Files.getNameWithoutExtension((String)reportModel.getClassName());
            className = Files.getFileExtension((String)reportModel.getClassName());
        }
        if (!Strings.isNullOrEmpty((String)packageName)) {
            this.writer.println(String.format("<div class='packagename'>%s</div>", packageName));
        }
        this.writer.println(String.format("<h2>%s</h2>", className));
        if (!Strings.isNullOrEmpty((String)reportModel.getDescription())) {
            this.writer.println(String.format("<div class='description'>%s</div>", reportModel.getDescription()));
        }
        this.closeDiv();
    }

    @Override
    public void visitEnd(ReportModel reportModel) {
        this.writeStatistics(reportModel);
        this.writer.println("</div> <!-- testcase-content -->");
        this.writer.println("</div> <!-- testcase -->");
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        ScenarioHtmlWriter scenarioHtmlWriter = scenarioModel.isCasesAsTable() ? new DataTableScenarioHtmlWriter(this.writer) : new MultiCaseScenarioHtmlWriter(this.writer);
        scenarioModel.accept(scenarioHtmlWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModelToFile(ReportModel model, HtmlTocWriter tocWriter, File file) {
        PrintWriter printWriter = CommonReportHelper.getPrintWriter(file);
        try {
            HtmlWriter htmlWriter = new HtmlWriter(printWriter);
            htmlWriter.write(model, tocWriter);
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }
}

