/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;

public class HtmlWriterUtils {
    private final PrintWriter writer;

    public HtmlWriterUtils(PrintWriter writer) {
        this.writer = writer;
    }

    public void writeHtmlHeader(String title) {
        this.writer.println("<!DOCTYPE html>");
        this.writer.println("<html><head>");
        this.writer.println("  <meta charset='utf-8'>");
        this.writer.println(String.format("  <title>%s</title>", title));
        this.writer.println("  <link href='style.css' rel='stylesheet'>");
        this.writer.println("</head>");
        this.writer.println("<body>");
    }

    public void writeHtmlFooter() {
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    public void writeDuration(long durationInNanos) {
        double durationInMs = (double)durationInNanos / 1000000.0;
        Formatter usFormatter = new Formatter(Locale.US);
        this.writer.print(usFormatter.format(" <span class='duration'>(%.2f ms)</span>", durationInMs));
        usFormatter.close();
    }
}

