/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.html.HtmlEscapers;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.html.HtmlTocWriter;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Tag;
import com.tngtech.jgiven.report.model.Word;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;

public class ScenarioHtmlWriter
extends ReportModelVisitor {
    final PrintWriter writer;
    ScenarioModel scenarioModel;
    ScenarioCaseModel scenarioCase;

    public ScenarioHtmlWriter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        this.scenarioModel = scenarioModel;
        this.writer.println("<div class='scenario'>");
        String id = scenarioModel.className + ":" + scenarioModel.description;
        this.writer.print(String.format("<h3 onclick='toggle(\"%s\")'>", id));
        this.writeStatusIcon(scenarioModel.getExecutionStatus());
        this.writer.print(" " + WordUtil.capitalize(scenarioModel.description));
        this.writeDuration(scenarioModel.getDurationInNanos());
        this.writer.println("</h3>");
        this.writeTagLine(scenarioModel);
        this.writer.println("<div class='scenario-body' id='" + id + "'>");
        this.writer.println("<div class='scenario-content'>");
    }

    public void writeStatusIcon(boolean success) {
        this.writeStatusIcon(success ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILED);
    }

    public void writeStatusIcon(ExecutionStatus executionStatus) {
        String iconClass = "icon-block";
        if (executionStatus == ExecutionStatus.FAILED) {
            iconClass = "icon-cancel";
        } else if (executionStatus == ExecutionStatus.SUCCESS) {
            iconClass = "icon-ok";
        }
        this.writer.print(String.format("<i class='%s'></i>", iconClass));
    }

    private void writeTagLine(ScenarioModel scenarioModel) {
        this.writer.print("<div class='tag-line'>");
        for (Tag tag : scenarioModel.tags) {
            this.printTag(tag);
        }
        this.writer.println("</div>");
    }

    private void printTag(Tag tag) {
        this.writer.print(ScenarioHtmlWriter.tagToHtml(tag));
    }

    public static String tagToHtml(Tag tag) {
        return String.format("<div class='tag tag-%s'><a href='%s'>%s</a></div>", tag.getName(), HtmlTocWriter.tagToFilename(tag), tag.toString());
    }

    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        this.writer.println("</div> <!-- scenario-content -->");
        this.writer.println(String.format("<div class='scenario-footer'><a href='%s.html'>%s</a></div>", scenarioModel.className, scenarioModel.className));
        this.writer.println("</div> <!-- scenario-body --> ");
        this.writer.println("</div>");
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        this.scenarioCase = scenarioCase;
        this.printCaseHeader(scenarioCase);
        String collapsed = scenarioCase.arguments.isEmpty() || this.scenarioModel.isCasesAsTable() ? "" : " collapsed";
        this.writer.println("<ul class='steps" + collapsed + "' id='" + this.getCaseId() + "'>");
    }

    private String getCaseId() {
        return this.scenarioModel.className + ":" + this.scenarioModel.description + ":" + this.scenarioCase.caseNr;
    }

    void printCaseHeader(ScenarioCaseModel scenarioCase) {
        this.writer.println(String.format("<div class='case %sCase'>", scenarioCase.success ? "passed" : "failed"));
        if (!scenarioCase.arguments.isEmpty()) {
            this.writer.print(String.format("<h4 onclick='toggle(\"%s\")'>", this.getCaseId()));
            this.writeStatusIcon(scenarioCase.success);
            this.writer.print(String.format(" Case %d: ", scenarioCase.caseNr));
            for (int i = 0; i < scenarioCase.arguments.size(); ++i) {
                if (this.scenarioModel.parameterNames.size() > i) {
                    this.writer.print(this.scenarioModel.parameterNames.get(i) + " = ");
                }
                this.writer.print(scenarioCase.arguments.get(i));
                if (i >= scenarioCase.arguments.size() - 1) continue;
                this.writer.print(", ");
            }
            this.writeDuration(scenarioCase.durationInNanos);
            this.writer.println("</h4>");
        }
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (!scenarioCase.success) {
            this.writer.println("<div class='failed'>Failed: " + scenarioCase.errorMessage + "</div>");
        }
        this.writer.println("</ul>");
        this.writer.println("</div><!-- case -->");
    }

    @Override
    public void visit(StepModel stepModel) {
        this.writer.print("<li>");
        boolean firstWord = true;
        for (Word word : stepModel.words) {
            if (!firstWord) {
                this.writer.print(' ');
            }
            String text = HtmlEscapers.htmlEscaper().escape(word.value);
            if (firstWord && word.isIntroWord) {
                this.writer.print(String.format("<span class='introWord'>%s</span>", WordUtil.capitalize(text)));
            } else if (word.isArg()) {
                this.printArg(word);
            } else {
                this.writer.print(text);
            }
            firstWord = false;
        }
        StepStatus status = stepModel.getStatus();
        if (status != StepStatus.PASSED) {
            String lowerCase = status.toString().toLowerCase();
            this.writer.print(String.format(" <span class='badge %s'>%s</span>", WordUtil.camelCase(lowerCase), lowerCase.replace('_', ' ')));
        }
        this.writeDuration(stepModel.getDurationInNanos());
        this.writer.println("</li>");
    }

    protected void writeDuration(long durationInNanos) {
        double durationInMs = (double)durationInNanos / 1000000.0;
        Formatter usFormatter = new Formatter(Locale.US);
        this.writer.print(usFormatter.format(" <span class='duration'>(%.2f ms)</span>", durationInMs));
        usFormatter.close();
    }

    private void printArg(Word word) {
        String value = word.getArgumentInfo().isCaseArg() ? this.formatCaseArgument(word) : HtmlEscapers.htmlEscaper().escape(word.value);
        value = this.escapeToHtml(value);
        String multiLine = value.contains("<br />") ? "multiline" : "";
        String caseClass = word.getArgumentInfo().isCaseArg() ? "caseArgument" : "argument";
        this.writer.print(String.format("<span class='%s %s'>%s</span>", caseClass, multiLine, value));
    }

    private String escapeToHtml(String value) {
        return value.replaceAll("(\r\n|\n)", "<br />");
    }

    String formatCaseArgument(Word word) {
        return HtmlEscapers.htmlEscaper().escape(word.value);
    }
}

