/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Charsets;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.html.HtmlWriter;
import com.tngtech.jgiven.report.html.HtmlWriterUtils;
import com.tngtech.jgiven.report.json.JsonModelTraverser;
import com.tngtech.jgiven.report.json.ReportModelFileHandler;
import com.tngtech.jgiven.report.model.ReportModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileHtmlReportGenerator
implements ReportModelFileHandler {
    private static final Logger log = LoggerFactory.getLogger(SingleFileHtmlReportGenerator.class);
    protected PrintWriter writer;
    protected HtmlWriterUtils utils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(File toDir, String targetFileName, File sourceDir) throws IOException {
        log.info("Generating file " + targetFileName + " to directory " + toDir);
        this.writer = new PrintWriter(new File(toDir, targetFileName), Charsets.UTF_8.name());
        this.utils = new HtmlWriterUtils(this.writer);
        try {
            this.writeStart();
            new JsonModelTraverser().traverseModels(sourceDir, this);
            this.writeEnd();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(this.writer);
            throw throwable;
        }
        ResourceUtil.close(this.writer);
    }

    public void writeStart() {
        this.utils.writeHtmlHeader("JGiven HTML Report");
        this.writer.println("<div class='linklist'>");
        this.writer.println("<h1>Acceptance Tests</h1>");
    }

    public void writeEnd() {
        this.writer.println("</div></body></html>");
    }

    @Override
    public void handleReportModel(ReportModel model, File file) {
        new HtmlWriter(this.writer).visit(model);
    }
}

