/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.html.HtmlTocWriter;
import com.tngtech.jgiven.report.html.HtmlWriter;
import com.tngtech.jgiven.report.html.ScenarioHtmlWriter;
import com.tngtech.jgiven.report.impl.CommonReportHelper;
import com.tngtech.jgiven.report.json.JsonModelTraverser;
import com.tngtech.jgiven.report.json.ReportModelFileHandler;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StatisticsCalculator;
import com.tngtech.jgiven.report.model.Tag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHtmlReportGenerator
implements ReportModelFileHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHtmlReportGenerator.class);
    private final List<ModelFile> models = Lists.newArrayList();
    private final Map<Tag, List<ScenarioModel>> tagMap = Maps.newHashMap();
    private final StatisticsCalculator statisticsCalculator = new StatisticsCalculator();
    private File toDir;

    public void generate(File toDir, File sourceDir) throws IOException {
        this.toDir = toDir;
        new JsonModelTraverser().traverseModels(sourceDir, this);
        this.writeEnd();
        this.copyFileToTargetDir("style.css");
        this.copyFileToTargetDir("default.css");
        this.copyFileToTargetDir("print.css");
        this.copyFileToTargetDir("report.js");
        this.copyFileToTargetDir("fontawesome.css");
        this.copyFileToTargetDir("fontawesome.ttf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileToTargetDir(String fileName) throws IOException {
        InputStream stream = null;
        FileOutputStream fileOutputStream = null;
        try {
            stream = this.getClass().getResourceAsStream("/com/tngtech/jgiven/report/html/" + fileName);
            File file = new File(this.toDir, fileName);
            fileOutputStream = new FileOutputStream(file);
            ByteStreams.copy((InputStream)stream, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            ResourceUtil.close(stream, fileOutputStream);
            throw throwable;
        }
        ResourceUtil.close(stream, fileOutputStream);
    }

    @Override
    public void handleReportModel(ReportModel model, File file) {
        String targetFileName = Files.getNameWithoutExtension((String)file.getName()) + ".html";
        File targetFile = new File(this.toDir, targetFileName);
        log.debug("Writing to file " + targetFile);
        try {
            ModelFile modelFile = new ModelFile();
            modelFile.model = model;
            modelFile.file = targetFile;
            this.models.add(modelFile);
            for (ScenarioModel scenario : model.getScenarios()) {
                for (Tag tag : scenario.tags) {
                    this.addToMap(tag, scenario);
                }
            }
        }
        catch (Exception e) {
            log.error("Error while trying to write to file " + file + ". " + e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void writeEnd() {
        HtmlTocWriter tocWriter = new HtmlTocWriter(this.tagMap, this.models);
        for (ModelFile modelFile : this.models) {
            HtmlWriter.writeModelToFile(modelFile.model, tocWriter, modelFile.file);
        }
        this.writeTagFiles(tocWriter);
        this.writeIndexFile(tocWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndexFile(HtmlTocWriter tocWriter) {
        File file = new File(this.toDir, "index.html");
        PrintWriter printWriter = CommonReportHelper.getPrintWriter(file);
        try {
            HtmlWriter htmlWriter = new HtmlWriter(printWriter);
            htmlWriter.writeHtmlHeader("Scenarios");
            ReportModel reportModel = new ReportModel();
            reportModel.setClassName(".Scenarios");
            tocWriter.writeToc(printWriter);
            htmlWriter.visit(reportModel);
            for (Tag tag : tocWriter.getSortedTags()) {
                printWriter.println(ScenarioHtmlWriter.tagToHtml(tag));
            }
            htmlWriter.visitEnd(reportModel);
            htmlWriter.writeHtmlFooter();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }

    private void writeTagFiles(HtmlTocWriter tocWriter) {
        if (this.tagMap.isEmpty()) {
            return;
        }
        for (Tag tag : this.tagMap.keySet()) {
            this.writeTagFile(tag, this.tagMap.get(tag), tocWriter);
        }
    }

    private void writeTagFile(Tag tag, List<ScenarioModel> value, HtmlTocWriter tocWriter) {
        try {
            ReportModel reportModel = new ReportModel();
            reportModel.setClassName(tag.getName());
            if (tag.getValue() != null) {
                reportModel.setClassName(reportModel.getClassName() + "." + tag.getValueString());
            }
            reportModel.setScenarios(value);
            reportModel.setDescription(tag.getDescription());
            String fileName = HtmlTocWriter.tagToFilename(tag);
            File targetFile = new File(this.toDir, fileName);
            HtmlWriter.writeToFile(targetFile, reportModel, tocWriter);
        }
        catch (Exception e) {
            log.error("Error while trying to write HTML file for tag " + tag.getName());
        }
    }

    private void addToMap(Tag tag, ScenarioModel scenario) {
        ArrayList list = this.tagMap.get(tag);
        if (list == null) {
            list = Lists.newArrayList();
            this.tagMap.put(tag, list);
        }
        list.add(scenario);
    }

    static class ModelFile {
        ReportModel model;
        File file;

        ModelFile() {
        }
    }
}

