/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseArgumentAnalyser {
    private static final Logger log = LoggerFactory.getLogger(CaseArgumentAnalyser.class);

    public void analyze(ReportModel model) {
        for (ScenarioModel scenarioModel : model.getScenarios()) {
            this.analyze(scenarioModel);
        }
    }

    public void analyze(ScenarioModel scenarioModel) {
        if (scenarioModel.getScenarioCases().size() < 2) {
            return;
        }
        CollectPhase collectPhase = new CollectPhase();
        scenarioModel.accept(collectPhase);
        try {
            this.reduceMatrix(collectPhase.argumentMatrix);
            scenarioModel.setCasesAsTable(this.allStepsEqual(collectPhase.allWords));
        }
        catch (IndexOutOfBoundsException e) {
            log.info("Scenario model " + scenarioModel.className + "." + scenarioModel.testMethodName + " has no homogene cases." + " Cannot analyse argument cases");
            scenarioModel.setCasesAsTable(false);
        }
    }

    private boolean allStepsEqual(List<List<Word>> allWords) {
        List<Word> firstWords = allWords.get(0);
        for (int i = 1; i < allWords.size(); ++i) {
            if (this.wordsAreEqual(firstWords, allWords.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean wordsAreEqual(List<Word> firstWords, List<Word> words) {
        if (firstWords.size() != words.size()) {
            return false;
        }
        for (int j = 0; j < words.size(); ++j) {
            if (firstWords.get(j).isArg() && firstWords.get(j).getArgumentInfo().isCaseArg() || firstWords.get(j).equals(words.get(j))) continue;
            return false;
        }
        return true;
    }

    private void reduceMatrix(List<List<ArgumentHolder>> argumentMatrix) {
        int nArguments = argumentMatrix.get(0).size();
        for (int iArg = 0; iArg < nArguments; ++iArg) {
            int iCase;
            LinkedHashSet currentSet = Sets.newLinkedHashSet();
            currentSet.addAll(argumentMatrix.get((int)0).get((int)iArg).params);
            for (iCase = 1; iCase < argumentMatrix.size(); ++iCase) {
                currentSet.retainAll(argumentMatrix.get((int)iCase).get((int)iArg).params);
            }
            if (currentSet.size() > 1) {
                log.warn("Could not disambiguate case arguments for argument " + iArg + ". Values: " + currentSet);
            } else if (currentSet.isEmpty()) {
                log.warn("Could not identify parameter index for argument " + iArg);
                continue;
            }
            for (iCase = 0; iCase < argumentMatrix.size(); ++iCase) {
                Word word = argumentMatrix.get((int)iCase).get((int)iArg).word;
                word.getArgumentInfo().setParameterIndex((Integer)currentSet.iterator().next());
            }
        }
    }

    static class CollectPhase
    extends ReportModelVisitor {
        List<List<ArgumentHolder>> argumentMatrix = Lists.newArrayList();
        List<ArgumentHolder> argumentsOfCurrentCase;
        List<List<Word>> allWords = Lists.newArrayList();
        List<Word> allWordsOfCurrentCase;
        ScenarioCaseModel currentCase;

        CollectPhase() {
        }

        @Override
        public void visit(ScenarioCaseModel scenarioCase) {
            this.currentCase = scenarioCase;
            this.argumentsOfCurrentCase = Lists.newArrayList();
            this.argumentMatrix.add(this.argumentsOfCurrentCase);
            this.allWordsOfCurrentCase = Lists.newArrayList();
            this.allWords.add(this.allWordsOfCurrentCase);
        }

        @Override
        public void visit(StepModel methodModel) {
            for (Word word : methodModel.words) {
                if (word.isArg()) {
                    ArgumentHolder holder = new ArgumentHolder();
                    holder.word = word;
                    holder.params = this.getMatchingIndices(word);
                    this.argumentsOfCurrentCase.add(holder);
                }
                this.allWordsOfCurrentCase.add(word);
            }
        }

        private Set<Integer> getMatchingIndices(Word word) {
            LinkedHashSet matchingIndices = Sets.newLinkedHashSet();
            for (int i = 0; i < this.currentCase.arguments.size(); ++i) {
                if (!Objects.equal((Object)word.value, (Object)this.currentCase.arguments.get(i))) continue;
                matchingIndices.add(i);
            }
            return matchingIndices;
        }
    }

    static class ArgumentHolder {
        Word word;
        Set<Integer> params;

        ArgumentHolder() {
        }
    }
}

