/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.report.impl.CaseArgumentAnalyser;
import com.tngtech.jgiven.report.json.ScenarioJsonWriter;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.text.PlainTextReporter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonReportHelper {
    private static final Logger log = LoggerFactory.getLogger(CommonReportHelper.class);

    public void finishReport(ReportModel model) {
        Optional<File> optionalReportDir;
        if (!Config.config().isReportEnabled()) {
            return;
        }
        new CaseArgumentAnalyser().analyze(model);
        if (Config.config().textReport()) {
            new PlainTextReporter().write(model).close();
        }
        if ((optionalReportDir = Config.config().getReportDir()).isPresent()) {
            File reportDir = (File)optionalReportDir.get();
            if (!reportDir.exists() && !reportDir.mkdirs()) {
                log.error("Could not create report directory " + reportDir);
            }
            File reportFile = new File(reportDir, model.getClassName() + ".json");
            log.info("Writing scenario report to file " + reportFile.getAbsolutePath());
            new ScenarioJsonWriter(model).write(reportFile);
        }
    }

    public static PrintWriter getPrintWriter(File file) {
        try {
            return new PrintWriter(file, Charsets.UTF_8.name());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static PrintWriter getPrintWriter(OutputStream outputStream) {
        try {
            return new PrintWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

