/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ReportModel {
    private String className;
    private String description;
    private List<ScenarioModel> scenarios = Lists.newArrayList();

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        List<ScenarioModel> sorted = this.sortByDescription();
        for (ScenarioModel m : sorted) {
            m.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    private List<ScenarioModel> sortByDescription() {
        ArrayList sorted = Lists.newArrayList(this.getScenarios());
        Collections.sort(sorted, new Comparator<ScenarioModel>(){

            @Override
            public int compare(ScenarioModel o1, ScenarioModel o2) {
                return o1.description.toLowerCase().compareTo(o2.description.toLowerCase());
            }
        });
        return sorted;
    }

    public ScenarioModel getLastScenarioModel() {
        return this.getScenarios().get(this.getScenarios().size() - 1);
    }

    public Optional<ScenarioModel> findScenarioModel(String scenarioDescription) {
        for (ScenarioModel model : this.getScenarios()) {
            if (!model.description.equals(scenarioDescription)) continue;
            return Optional.of((Object)model);
        }
        return Optional.absent();
    }

    public StepModel getFirstStepModelOfLastScenario() {
        return this.getLastScenarioModel().getCase((int)0).steps.get(0);
    }

    public void addScenarioModel(ScenarioModel currentScenarioModel) {
        this.getScenarios().add(currentScenarioModel);
    }

    public String getSimpleClassName() {
        return (String)Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)this.getClassName()));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<ScenarioModel> getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(List<ScenarioModel> scenarios) {
        this.scenarios = scenarios;
    }
}

