/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.impl.intercept.InvocationMode;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ExecutionStatusCalculator;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Word;
import java.util.Arrays;
import java.util.List;

public class ScenarioCaseModel {
    public int caseNr;
    public List<StepModel> steps = Lists.newArrayList();
    public List<String> arguments = Lists.newArrayList();
    public boolean success = true;
    public String errorMessage;
    public long durationInNanos;

    public StepModel addStep(String name, List<Word> words, InvocationMode mode) {
        StepModel stepModel = new StepModel();
        stepModel.name = name;
        stepModel.words = words;
        stepModel.setStatus(this.toStepStatus(mode));
        this.steps.add(stepModel);
        return stepModel;
    }

    private StepStatus toStepStatus(InvocationMode mode) {
        switch (mode) {
            case NORMAL: {
                return StepStatus.PASSED;
            }
            case FAILED: {
                return StepStatus.FAILED;
            }
            case NOT_IMPLEMENTED_YET: {
                return StepStatus.NOT_IMPLEMENTED_YET;
            }
            case SKIPPED: {
                return StepStatus.SKIPPED;
            }
        }
        throw new IllegalArgumentException(mode.toString());
    }

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        for (StepModel step : this.steps) {
            step.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    public void addArguments(String ... args) {
        this.arguments.addAll(Arrays.asList(args));
    }

    public void addStep(StepModel stepModel) {
        this.steps.add(stepModel);
    }

    public StepModel getStep(int i) {
        return this.steps.get(i);
    }

    public void setDurationInNanoes(long durationInNanos) {
        this.durationInNanos = durationInNanos;
    }

    public long getDurationInNanos() {
        return this.durationInNanos;
    }

    public ExecutionStatus getExecutionStatus() {
        ExecutionStatusCalculator executionStatusCalculator = new ExecutionStatusCalculator();
        this.accept(executionStatusCalculator);
        return executionStatusCalculator.executionStatus();
    }
}

