/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Word;
import java.util.Arrays;
import java.util.List;

public class StepModel {
    public String name;
    public List<Word> words = Lists.newArrayList();
    private StepStatus status = StepStatus.PASSED;
    private long durationInNanos;

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
    }

    public String getCompleteSentence() {
        return Joiner.on((char)' ').join(this.words);
    }

    public StepModel addWords(Word ... words) {
        this.words.addAll(Arrays.asList(words));
        return this;
    }

    public boolean isNotImplementedYet() {
        return this.getStatus() == StepStatus.NOT_IMPLEMENTED_YET;
    }

    public boolean isFailed() {
        return this.getStatus() == StepStatus.FAILED;
    }

    public boolean isSkipped() {
        return this.getStatus() == StepStatus.SKIPPED;
    }

    public StepStatus getStatus() {
        return this.status;
    }

    public void setStatus(StepStatus status) {
        this.status = status;
    }

    public long getDurationInNanos() {
        return this.durationInNanos;
    }

    public void setDurationInNanos(long durationInNanos) {
        this.durationInNanos = durationInNanos;
    }
}

