/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import com.tngtech.jgiven.report.text.PlainTextScenarioWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DataTablePlainTextScenarioWriter
extends PlainTextScenarioWriter {
    public DataTablePlainTextScenarioWriter(PrintWriter writer, boolean withColor) {
        super(writer, withColor);
    }

    @Override
    public void visit(StepModel stepModel) {
        if (this.currentCaseModel.caseNr > 1) {
            return;
        }
        super.visit(stepModel);
    }

    @Override
    protected String wordToString(Word word) {
        int argIndex;
        if (word.isArg() && word.getArgumentInfo().isCaseArg() && (argIndex = word.getArgumentInfo().getParameterIndex()) < this.currentScenarioModel.parameterNames.size()) {
            return "<" + this.currentScenarioModel.parameterNames.get(argIndex) + ">";
        }
        return super.wordToString(word);
    }

    @Override
    protected void printCaseLine(ScenarioCaseModel scenarioCase) {
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.caseNr == 1) {
            super.visitEnd(scenarioCase);
        }
    }

    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        StringBuilder formatBuilder = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        List<Integer> columnWidths = this.getMaxColumnWidth(scenarioModel);
        for (int width : columnWidths) {
            formatBuilder.append("| %" + width + "s ");
            lineBuilder.append("+");
            lineBuilder.append(Strings.repeat((String)"-", (int)(width + 2)));
        }
        formatBuilder.append("|");
        lineBuilder.append("+");
        String formatString = formatBuilder.toString();
        String caseIndent = "    ";
        this.writer.println("  Cases:\n");
        this.writer.println(caseIndent + String.format(formatString, scenarioModel.parameterNames.toArray()));
        this.writer.println(caseIndent + lineBuilder);
        for (ScenarioCaseModel c : scenarioModel.getScenarioCases()) {
            this.writer.println(caseIndent + String.format(formatString, c.arguments.toArray()));
        }
    }

    private List<Integer> getMaxColumnWidth(ScenarioModel scenarioModel) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < scenarioModel.parameterNames.size(); ++i) {
            int maxWidth = scenarioModel.parameterNames.get(i).length();
            for (ScenarioCaseModel c : scenarioModel.getScenarioCases()) {
                int width;
                if (c.arguments.size() <= i || (width = c.arguments.get(i).length()) <= maxWidth) continue;
                maxWidth = width;
            }
            result.add(maxWidth);
        }
        return result;
    }
}

