/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.impl.CommonReportHelper;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.text.DataTablePlainTextScenarioWriter;
import com.tngtech.jgiven.report.text.PlainTextScenarioWriter;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.fusesource.jansi.Ansi;

public class PlainTextReporter
extends PlainTextWriter {
    private static final boolean COLOR_ENABLED = Config.config().textColorEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ReportModel model) throws UnsupportedEncodingException {
        String string;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PlainTextReporter textWriter = new PlainTextReporter(printWriter, false);
        try {
            textWriter.write(model);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
        return string;
    }

    public PlainTextReporter() {
        this(COLOR_ENABLED);
    }

    public PlainTextReporter(boolean withColor) {
        this(CommonReportHelper.getPrintWriter(System.out), withColor);
    }

    public PlainTextReporter(PrintWriter printWriter, boolean withColor) {
        super(printWriter, withColor);
    }

    public PlainTextReporter write(ReportModel model) {
        model.accept(this);
        return this;
    }

    public void close() {
        this.writer.close();
    }

    public void write(ScenarioModel scenarioModel) {
        scenarioModel.accept(this);
    }

    @Override
    public void visit(ReportModel multiScenarioModel) {
        this.writer.println();
        String title = this.withColor(Ansi.Color.RED, Ansi.Attribute.INTENSITY_BOLD, "Test Class: ");
        title = title + this.withColor(Ansi.Color.RED, multiScenarioModel.getClassName());
        this.println(Ansi.Color.RED, title);
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        if (scenarioModel.isCasesAsTable()) {
            scenarioModel.accept(new DataTablePlainTextScenarioWriter(this.writer, this.withColor));
        } else {
            scenarioModel.accept(new PlainTextScenarioWriter(this.writer, this.withColor));
        }
    }
}

