/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.util.List;
import org.fusesource.jansi.Ansi;

public class PlainTextScenarioWriter
extends PlainTextWriter {
    private static final String INDENT = "   ";
    protected ScenarioModel currentScenarioModel;
    protected ScenarioCaseModel currentCaseModel;
    private int maxFillWordLength;

    public PlainTextScenarioWriter(PrintWriter printWriter, boolean withColor) {
        super(printWriter, withColor);
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        this.writer.print("\n" + this.withColor(Ansi.Color.MAGENTA, Ansi.Attribute.INTENSITY_BOLD, " Scenario: "));
        this.println(Ansi.Color.MAGENTA, scenarioModel.description + "\n");
        this.currentScenarioModel = scenarioModel;
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (!scenarioCase.success) {
            this.writer.println();
            this.writer.print("FAILED: " + scenarioCase.errorMessage);
        }
        this.writer.println();
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        if (this.currentScenarioModel.getScenarioCases().size() > 1) {
            this.printCaseLine(scenarioCase);
        }
        this.maxFillWordLength = new MaxFillWordLengthGetter().getLength(scenarioCase);
        this.currentCaseModel = scenarioCase;
    }

    protected void printCaseLine(ScenarioCaseModel scenarioCase) {
        this.writer.print("  Case " + scenarioCase.caseNr + ": ");
        List<String> arguments = scenarioCase.arguments;
        if (!arguments.isEmpty()) {
            List<String> parameterNames = this.currentScenarioModel.parameterNames;
            for (int i = 0; i < arguments.size(); ++i) {
                if (i < parameterNames.size()) {
                    this.writer.print(parameterNames.get(i) + " = ");
                }
                this.writer.print(arguments.get(i));
                if (i == arguments.size() - 1) continue;
                this.writer.print(", ");
            }
        }
        this.writer.println();
    }

    @Override
    public void visit(StepModel stepModel) {
        String intro = "";
        List<Word> words = stepModel.words;
        intro = words.get((int)0).isIntroWord ? this.withColor(Ansi.Color.BLUE, Ansi.Attribute.INTENSITY_BOLD, INDENT + String.format("%" + this.maxFillWordLength + "s ", WordUtil.capitalize(words.get((int)0).value))) : INDENT + words.get((int)0).value;
        String rest = this.joinWords(words.subList(1, words.size()));
        if (stepModel.isNotImplementedYet()) {
            rest = this.withColor(Ansi.Color.BLACK, true, Ansi.Attribute.INTENSITY_FAINT, rest + " (not implemented yet)");
        } else if (stepModel.isSkipped()) {
            rest = this.withColor(Ansi.Color.BLACK, true, Ansi.Attribute.INTENSITY_FAINT, rest + " (skipped)");
        } else if (stepModel.isFailed()) {
            rest = this.withColor(Ansi.Color.RED, true, Ansi.Attribute.INTENSITY_FAINT, rest);
            rest = rest + this.withColor(Ansi.Color.RED, true, Ansi.Attribute.INTENSITY_BOLD, " (failed)");
        }
        this.writer.println(intro + rest);
    }

    private String joinWords(List<Word> words) {
        return Joiner.on((String)" ").join(Iterables.transform(words, (Function)new Function<Word, String>(){

            public String apply(Word input) {
                return PlainTextScenarioWriter.this.wordToString(input);
            }
        }));
    }

    protected String wordToString(Word word) {
        if (word.isArg() && !this.isInt(word)) {
            return "'" + word.value + "'";
        }
        return word.value;
    }

    private boolean isInt(Word word) {
        try {
            Integer.valueOf(word.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static class MaxFillWordLengthGetter
    extends ReportModelVisitor {
        private int maxLength;

        MaxFillWordLengthGetter() {
        }

        public int getLength(ScenarioCaseModel scenarioCase) {
            scenarioCase.accept(this);
            return this.maxLength;
        }

        @Override
        public void visit(StepModel stepModel) {
            int length;
            Word word = stepModel.words.get(0);
            if (word.isIntroWord && (length = word.value.length()) > this.maxLength) {
                this.maxLength = length;
            }
        }
    }
}

