/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.tngtech.jgiven.exception.JGivenExecutionException;
import com.tngtech.jgiven.exception.JGivenInjectionException;
import com.tngtech.jgiven.exception.JGivenUserException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class ReflectionUtil {
    private static Logger log = Logger.getLogger(ReflectionUtil.class);

    public static void forEachField(final Object object, Class<?> clazz, final FieldPredicate predicate, final FieldAction action) {
        ReflectionUtil.forEachSuperClass(clazz, new ClassAction(){

            @Override
            public void act(Class<?> clazz) throws Exception {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!predicate.isTrue(field)) continue;
                    action.act(object, field);
                }
            }
        });
    }

    public static void forEachMethod(final Object object, Class<?> clazz, final Class<? extends Annotation> annotation, final MethodAction action) {
        ReflectionUtil.forEachSuperClass(clazz, new ClassAction(){

            @Override
            public void act(Class<?> clazz) throws Exception {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    action.act(object, method);
                }
            }
        });
    }

    public static void forEachSuperClass(Class<?> clazz, ClassAction action) {
        try {
            action.act(clazz);
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                ReflectionUtil.forEachSuperClass(superclass, action);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static FieldPredicate hasAtLeastOneAnnotation(final Class<? extends Annotation> ... annotation) {
        return new FieldPredicate(){

            @Override
            public boolean isTrue(Field field) throws Exception {
                for (Class clazz : annotation) {
                    if (!field.isAnnotationPresent(clazz)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FieldPredicate allFields() {
        return new FieldPredicate(){

            @Override
            public boolean isTrue(Field field) throws Exception {
                return true;
            }
        };
    }

    public static FieldPredicate nonStaticField() {
        return new FieldPredicate(){

            @Override
            public boolean isTrue(Field field) throws Exception {
                return !Modifier.isStatic(field.getModifiers());
            }
        };
    }

    public static Optional<Method> findMethodTransitively(Class<?> clazz, String methodName) {
        if (clazz == null) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)clazz.getDeclaredMethod(methodName, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return ReflectionUtil.findMethodTransitively(clazz.getSuperclass(), methodName);
        }
    }

    public static <T> T newInstance(Class<T> value) {
        try {
            return value.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeMethod(Object object, Method method, String errorDescription) {
        log.debug((Object)("Executing method " + method + " of class " + object.getClass()));
        ReflectionUtil.makeAccessible(method, errorDescription);
        try {
            method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)"Caught exception:", (Throwable)e);
            throw new JGivenExecutionException("Could not execute " + ReflectionUtil.toReadableString(method) + errorDescription + ", because it requires parameters. " + "Remove the parameters and try again.", e);
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Caught exception:", (Throwable)e);
            throw new JGivenExecutionException("Could not execute " + ReflectionUtil.toReadableString(method) + errorDescription + ", because of insuffient access rights. " + "Either make the method public or disable your security manager while executing JGiven tests.", e);
        }
        catch (InvocationTargetException e) {
            throw new JGivenUserException(method, errorDescription, e.getCause());
        }
    }

    public static List<Object> getAllNonStaticFieldValuesFrom(final Class<?> clazz, Object target, final String errorDescription) {
        final ArrayList<Object> fieldValues = new ArrayList<Object>();
        ReflectionUtil.forEachField(target, clazz, ReflectionUtil.nonStaticField(), new FieldAction(){

            @Override
            public void act(Object target, Field field) throws Exception {
                ReflectionUtil.makeAccessible(field, "");
                try {
                    fieldValues.add(field.get(target));
                }
                catch (IllegalAccessException e) {
                    log.warn((Object)String.format("Not able to access field '%s' containing in '%s'." + errorDescription, field.getName(), clazz.getSimpleName()), (Throwable)e);
                }
            }
        });
        return fieldValues;
    }

    public static void setField(Field field, Object object, Object value, String errorDescription) {
        ReflectionUtil.makeAccessible(field, errorDescription);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)"Caught exception:", (Throwable)e);
            throw new JGivenInjectionException("Could not set " + ReflectionUtil.toReadableString(field) + errorDescription + " to value " + value + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Caught exception:", (Throwable)e);
            throw new JGivenInjectionException("Could not set " + ReflectionUtil.toReadableString(field) + errorDescription + ", because of insuffient access rights. " + "Either make the field public or disable your security manager while executing JGiven tests.", e);
        }
    }

    public static void makeAccessible(AccessibleObject object, String errorDescription) {
        try {
            object.setAccessible(true);
        }
        catch (SecurityException e) {
            log.debug((Object)"Caught exception: ", (Throwable)e);
            log.warn((Object)("Could not make " + ReflectionUtil.toReadableString(object) + errorDescription + " accessible, trying to access it nevertheless and hoping for the best."));
        }
    }

    public static String toReadableString(AccessibleObject object) {
        if (object instanceof Method) {
            Method method = (Method)object;
            return "method '" + method.getName() + "' of class '" + method.getDeclaringClass().getSimpleName() + "'";
        }
        if (object instanceof Field) {
            Field field = (Field)object;
            return "field '" + field.getName() + "' of class '" + field.getDeclaringClass().getSimpleName() + "'";
        }
        if (object instanceof Constructor) {
            Constructor constructor = (Constructor)object;
            return "constructor '" + constructor.getName() + "' of class '" + constructor.getDeclaringClass().getSimpleName() + "'";
        }
        return null;
    }

    public static List<Method> getNonStaticMethod(Method[] declaredMethods) {
        return FluentIterable.from(Arrays.asList(declaredMethods)).filter((Predicate)new Predicate<Method>(){

            public boolean apply(Method input) {
                return (input.getModifiers() & 8) == 0;
            }
        }).toList();
    }

    public static interface MethodAction {
        public void act(Object var1, Method var2) throws Exception;
    }

    public static interface FieldAction {
        public void act(Object var1, Field var2) throws Exception;
    }

    public static interface ClassAction {
        public void act(Class<?> var1) throws Exception;
    }

    public static interface FieldPredicate {
        public boolean isTrue(Field var1) throws Exception;
    }
}

