/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.tngtech.jgiven.report.html.PackageTocBuilder;
import com.tngtech.jgiven.report.html.StaticHtmlReportGenerator;
import com.tngtech.jgiven.report.model.ReportStatistics;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.Tag;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class HtmlTocWriter {
    protected PrintWriter writer;
    private final Map<Tag, List<ScenarioModel>> tagMap;
    private final PackageTocBuilder.PackageToc packageToc;
    private final ImmutableListMultimap<String, Tag> groupedTags;
    private final ReportStatistics totalStatistics;

    public HtmlTocWriter(Map<Tag, List<ScenarioModel>> tagMap, PackageTocBuilder.PackageToc packageToc, ReportStatistics totalStatistics) {
        this.tagMap = tagMap;
        this.packageToc = packageToc;
        this.totalStatistics = totalStatistics;
        this.groupedTags = this.getGroupedTags();
    }

    public void writeToc(PrintWriter writer) {
        this.writer = writer;
        writer.println("<div id='col-container'>");
        writer.println("<div id='leftpane'>");
        writer.println("<div id='toc'>");
        writer.println("<i class='icon-cancel' onclick='hideToc()'></i>");
        this.writeSearchInput();
        this.writeSummary();
        this.writePackages();
        this.writeTagLinks();
        writer.println("</div> <!-- toc -->");
        writer.println("</div> <!-- leftpane -->");
    }

    private void writeSummary() {
        this.writer.println("<h3><a href='index.html'>Summary</a></h3>");
        this.writer.println("<ul>");
        this.writeLink(this.totalStatistics.numScenarios, "all.html", "All Scenarios");
        this.writeLink(this.totalStatistics.numPendingScenarios, "pending.html", "Pending Scenarios");
        this.writeLink(this.totalStatistics.numFailedScenarios, "failed.html", "Failed Scenarios");
        this.writer.println("</ul>");
    }

    private void writeLink(int count, String fileName, String title) {
        if (count > 0) {
            this.writer.print("<li><a href='" + fileName + "'>" + title);
            this.writer.println(" <span class='badge count'>" + count + "</span></a>");
        }
    }

    private void writeSearchInput() {
        this.writer.println("<input class='search-input' id='toc-search-input' placeholder='enter regexp to search in toc' onkeydown='searchChanged(event)'></input>");
    }

    private void writePackages() {
        this.writer.println("<h3>Test Classes</h3>");
        this.writer.println("<ul>");
        this.printPackageToc("", this.packageToc);
        this.writer.println("</ul>");
    }

    private void printPackageTocs(Iterable<PackageTocBuilder.PackageToc> tocs) {
        for (PackageTocBuilder.PackageToc toc : tocs) {
            this.printPackageToc("", toc);
        }
    }

    private void printPackageToc(String prefix, PackageTocBuilder.PackageToc toc) {
        String name = prefix + toc.getLastName();
        if (toc.files.isEmpty() && toc.packages.size() == 1) {
            String newPrefix = name.equals("") ? "" : name + ".";
            this.printPackageToc(newPrefix, toc.packages.get(0));
        } else {
            if (!toc.name.equals("")) {
                this.writer.print("<li><h4 class='packagename' onclick='toggle(\"" + toc.name + "\")'>" + name + "</h4>");
                String collapsed = "collapsed";
                this.writer.println("<ul class='" + collapsed + "' id='" + toc.name + "'>");
            }
            this.printPackageTocs(toc.packages);
            this.printClassLinks(toc.files);
            if (!toc.name.equals("")) {
                this.writer.print("</ul></li>");
            }
        }
    }

    private void printClassLinks(List<StaticHtmlReportGenerator.ModelFile> files) {
        for (StaticHtmlReportGenerator.ModelFile modelFile : files) {
            this.writeClassLink(modelFile);
        }
    }

    private void writeClassLink(StaticHtmlReportGenerator.ModelFile model) {
        this.writer.print(String.format("<li><a href='%s' >%s</a></li>", model.file.getName(), model.model.getSimpleClassName()));
    }

    private void writeTagLinks() {
        if (this.tagMap.isEmpty()) {
            return;
        }
        this.writer.println("<h3>Tags</h3>");
        this.writer.println("<ul>");
        List orderedKeys = Ordering.natural().sortedCopy((Iterable)this.groupedTags.keySet());
        for (String key : orderedKeys) {
            this.writer.println("<li>");
            String tagId = "tag" + key;
            this.writer.println("<h4 onclick='toggle(\"" + tagId + "\")'>" + key + "</h4>");
            this.writer.println("<ul id='" + tagId + "' class='collapsed'>");
            List sortedTags = Ordering.usingToString().sortedCopy((Iterable)this.groupedTags.get((Object)key));
            for (Tag tag : sortedTags) {
                this.writeTagLink(tag, this.tagMap.get(tag));
            }
            this.writer.println("</ul>");
        }
        this.writer.println("</ul>");
    }

    private ImmutableListMultimap<String, Tag> getGroupedTags() {
        ImmutableListMultimap multiMap = Multimaps.index(this.tagMap.keySet(), (Function)new Function<Tag, String>(){

            public String apply(Tag input) {
                return input.getName();
            }
        });
        return multiMap;
    }

    public List<Tag> getSortedTags() {
        ArrayList sortedTags = Lists.newArrayList(this.tagMap.keySet());
        Collections.sort(sortedTags, new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return sortedTags;
    }

    private void writeTagLink(Tag tag, List<ScenarioModel> list) {
        this.writer.println(String.format("<li><a href='%s'>%s</a>", HtmlTocWriter.tagToFilename(tag), tag.toString()));
    }

    static String tagToFilename(Tag tag) {
        String fileName = HtmlTocWriter.escape(tag.getName());
        if (tag.getValue() != null) {
            fileName = tag.getValue().getClass().isArray() ? fileName + "-" + HtmlTocWriter.escape(Joiner.on((char)'-').join((Object[])((String[])tag.getValue()))) : fileName + "-" + HtmlTocWriter.escape((String)tag.getValue());
        }
        return fileName.substring(0, Math.min(fileName.length(), 255)) + ".html";
    }

    static String escape(String string) {
        return string.replaceAll("[^\\p{Alnum}-]", "_");
    }
}

