/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.tngtech.jgiven.impl.util.DurationFormatter;
import com.tngtech.jgiven.impl.util.PrintWriterUtil;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.html.HtmlTocWriter;
import com.tngtech.jgiven.report.html.HtmlWriterUtils;
import com.tngtech.jgiven.report.html.ReportModelHtmlWriter;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportStatistics;
import java.io.File;
import java.io.PrintWriter;

public class StatisticsPageHtmlWriter {
    private final HtmlTocWriter tocWriter;
    private final ReportStatistics statistics;
    private PrintWriter printWriter;
    private HtmlWriterUtils utils;

    public StatisticsPageHtmlWriter(HtmlTocWriter tocWriter, ReportStatistics statistics) {
        this.tocWriter = tocWriter;
        this.statistics = statistics;
    }

    public void write(File toDir) {
        this.writeIndexFile(toDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndexFile(File toDir) {
        File file = new File(toDir, "index.html");
        this.printWriter = PrintWriterUtil.getPrintWriter(file);
        this.utils = new HtmlWriterUtils(this.printWriter);
        try {
            ReportModelHtmlWriter htmlWriter = new ReportModelHtmlWriter(this.printWriter);
            htmlWriter.writeHtmlHeader("Summary");
            ReportModel reportModel = new ReportModel();
            reportModel.setClassName(".Summary");
            this.tocWriter.writeToc(this.printWriter);
            htmlWriter.visit(reportModel);
            this.writeStatistics();
            htmlWriter.visitEnd(reportModel);
            htmlWriter.writeHtmlFooter();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(this.printWriter);
            throw throwable;
        }
        ResourceUtil.close(this.printWriter);
    }

    private void writeStatistics() {
        this.printWriter.write("<div class='statistics-line'>");
        this.writeStatisticNumber(this.statistics.numClasses, "classes");
        this.writeStatisticsNumberWithLink(this.statistics.numScenarios, "scenarios", "all.html");
        this.writeStatisticNumber(this.statistics.numCases, "cases");
        this.writeStatisticNumber(this.statistics.numSteps, "steps");
        this.writeStatisticsNumberWithLink(this.statistics.numPendingScenarios, "pending scenarios", "pending.html");
        String failedClass = this.statistics.numFailedScenarios > 0 ? "failed" : "";
        this.printWriter.write("<div class='statistics-number " + failedClass + "'><a href='failed.html'><i>" + this.statistics.numFailedScenarios + "</i><br/><b>failed scenarios</b></a></div>");
        this.writeStatisticNumber(DurationFormatter.format(this.statistics.durationInNanos), "total time");
        long averageNanos = this.statistics.numCases != 0 ? this.statistics.durationInNanos / (long)this.statistics.numCases : 0L;
        this.writeStatisticNumber(DurationFormatter.format(averageNanos), "time / case");
        this.printWriter.println("</div>");
    }

    private void writeStatisticsNumberWithLink(int number, String title, String fileName) {
        this.printWriter.write("<div class='statistics-number'><a href='" + fileName + "'><i>" + number + "</i><br/><b>" + title + "</b></a></div>");
    }

    private void writeStatisticNumber(int number, String name) {
        this.writeStatisticNumber(number + "", name);
    }

    private void writeStatisticNumber(String number, String name) {
        this.printWriter.write("<div class='statistics-number'><i>" + number + "</i><br/><b>" + name + "</b></div>");
    }
}

