/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.CasesAsTable;
import com.tngtech.jgiven.annotation.Description;
import com.tngtech.jgiven.annotation.ExtendedDescription;
import com.tngtech.jgiven.annotation.Format;
import com.tngtech.jgiven.annotation.Formatf;
import com.tngtech.jgiven.annotation.IsTag;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.ScenarioDescription;
import com.tngtech.jgiven.config.AbstractJGivenConfiguraton;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.config.TagConfiguration;
import com.tngtech.jgiven.format.ArgumentFormatter;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.PrintfFormatter;
import com.tngtech.jgiven.impl.intercept.InvocationMode;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepFormatter;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.StepStatus;
import com.tngtech.jgiven.report.model.Tag;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportModelBuilder
implements ScenarioListener {
    private static final Logger log = LoggerFactory.getLogger(ReportModelBuilder.class);
    private ScenarioModel currentScenarioModel;
    private ScenarioCaseModel currentScenarioCase;
    private ReportModel reportModel;
    private Word introWord;
    private AbstractJGivenConfiguraton configuration = new DefaultConfiguration();
    private long scenarioStartedNanos;

    public ReportModelBuilder() {
        this(new ReportModel());
    }

    public ReportModelBuilder(ReportModel scenarioCollectionModel) {
        this.setReportModel(scenarioCollectionModel);
    }

    public void setReportModel(ReportModel reportModel) {
        this.reportModel = reportModel;
    }

    @Override
    public void scenarioStarted(String description) {
        this.scenarioStartedNanos = System.nanoTime();
        String readableDescription = description;
        if (description.contains("_")) {
            readableDescription = description.replace('_', ' ');
        } else if (!description.contains(" ")) {
            readableDescription = this.camelCaseToReadableText(description);
        }
        this.currentScenarioCase = new ScenarioCaseModel();
        this.currentScenarioModel = (ScenarioModel)this.reportModel.findScenarioModel(readableDescription).orNull();
        if (this.currentScenarioModel == null) {
            this.currentScenarioModel = new ScenarioModel();
            this.currentScenarioModel.className = this.reportModel.getClassName();
            this.reportModel.getScenarios().add(this.currentScenarioModel);
        }
        this.currentScenarioModel.addCase(this.currentScenarioCase);
        this.currentScenarioModel.description = readableDescription;
    }

    private String camelCaseToReadableText(String camelCase) {
        String scenarioDescription = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, camelCase).replace('_', ' ');
        return WordUtil.capitalize(scenarioDescription);
    }

    public void addStepMethod(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode) {
        StepModel stepModel = new StepModel();
        Description description = paramMethod.getAnnotation(Description.class);
        stepModel.name = description != null ? description.value() : ReportModelBuilder.nameWithoutUnderlines(paramMethod);
        ExtendedDescription extendedDescriptionAnnotation = paramMethod.getAnnotation(ExtendedDescription.class);
        if (extendedDescriptionAnnotation != null) {
            stepModel.setExtendedDescription(extendedDescriptionAnnotation.value());
        }
        List<StepFormatter.Formatting<?>> formatters = this.getFormatters(paramMethod.getParameterAnnotations());
        stepModel.words = new StepFormatter(stepModel.name, arguments, formatters).buildFormattedWords();
        if (this.introWord != null) {
            stepModel.words.add(0, this.introWord);
            this.introWord = null;
        }
        stepModel.setStatus(mode.toStepStatus());
        this.writeStep(stepModel);
    }

    @Override
    public void introWordAdded(String fillWord) {
        this.introWord = new Word();
        this.introWord.setIntroWord(true);
        this.introWord.setValue(fillWord);
    }

    private List<StepFormatter.Formatting<?>> getFormatters(Annotation[][] parameterAnnotations) {
        ArrayList res = Lists.newArrayList();
        for (Annotation[] annotations : parameterAnnotations) {
            res.add(this.getFormatting(annotations));
        }
        return res;
    }

    private StepFormatter.Formatting<?> getFormatting(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            try {
                if (annotation instanceof Format) {
                    Format arg = (Format)annotation;
                    return new StepFormatter.Formatting(arg.value().newInstance(), arg.args());
                }
                if (!(annotation instanceof Formatf)) continue;
                Formatf arg = (Formatf)annotation;
                return new StepFormatter.Formatting((ArgumentFormatter)PrintfFormatter.class.newInstance(), arg.value());
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    public void writeStep(StepModel stepModel) {
        this.getCurrentScenarioCase().addStep(stepModel);
    }

    private ScenarioCaseModel getCurrentScenarioCase() {
        if (this.currentScenarioCase == null) {
            this.scenarioStarted("An Undescribed Scenario");
        }
        return this.currentScenarioCase;
    }

    @Override
    public void stepMethodInvoked(Method paramMethod, List<NamedArgument> arguments, InvocationMode mode) {
        if (!this.isStepMethod(paramMethod)) {
            return;
        }
        this.addStepMethod(paramMethod, arguments, mode);
    }

    public boolean isStepMethod(Method paramMethod) {
        return Modifier.isPublic(paramMethod.getModifiers());
    }

    public void setMethodName(String methodName) {
        this.currentScenarioModel.testMethodName = methodName;
    }

    public void setArguments(List<String> arguments) {
        this.currentScenarioCase.setExplicitArguments(arguments);
    }

    public void setParameterNames(List<String> parameterNames) {
        this.currentScenarioModel.setExplicitParameters(parameterNames);
    }

    public void setClassName(String name) {
        this.reportModel.setClassName(name);
    }

    public void setSuccess(boolean success) {
        this.currentScenarioCase.success = success;
    }

    public void setErrorMessage(String message) {
        this.currentScenarioCase.errorMessage = message;
    }

    private static String nameWithoutUnderlines(Method paramMethod) {
        return paramMethod.getName().replace('_', ' ');
    }

    public ReportModel getScenarioCollectionModel() {
        return this.reportModel;
    }

    @Override
    public void stepMethodFailed(Throwable t) {
        if (!this.currentScenarioCase.steps.isEmpty()) {
            this.currentScenarioCase.steps.get(this.currentScenarioCase.steps.size() - 1).setStatus(StepStatus.FAILED);
        }
    }

    @Override
    public void stepMethodFinished(long durationInNanos) {
        if (!this.currentScenarioCase.steps.isEmpty()) {
            this.currentScenarioCase.steps.get(this.currentScenarioCase.steps.size() - 1).setDurationInNanos(durationInNanos);
        }
    }

    @Override
    public void scenarioFailed(Throwable e) {
        this.setSuccess(false);
        this.setErrorMessage(e.getMessage());
    }

    @Override
    public void scenarioStarted(Method method, List<NamedArgument> namedArguments) {
        this.readConfiguration(method.getDeclaringClass());
        this.readAnnotations(method);
        this.setParameterNames(this.getNames(namedArguments));
        this.setMethodName(method.getName());
        this.setArguments(this.toStringList(this.getValues(namedArguments)));
    }

    private List<Object> getValues(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.value);
        }
        return result;
    }

    private List<String> getNames(List<NamedArgument> namedArguments) {
        ArrayList result = Lists.newArrayList();
        for (NamedArgument a : namedArguments) {
            result.add(a.name);
        }
        return result;
    }

    private void readConfiguration(Class<?> testClass) {
        this.configuration = ConfigurationUtil.getConfiguration(testClass);
    }

    private List<String> toStringList(Collection<?> arguments) {
        ArrayList result = Lists.newArrayList();
        for (Object o : arguments) {
            result.add(new DefaultFormatter().format(o, new String[0]));
        }
        return result;
    }

    private void readAnnotations(Method method) {
        String scenarioDescription = method.getName();
        if (method.isAnnotationPresent(ScenarioDescription.class)) {
            scenarioDescription = method.getAnnotation(ScenarioDescription.class).value();
        } else if (method.isAnnotationPresent(Description.class)) {
            scenarioDescription = method.getAnnotation(Description.class).value();
        }
        this.scenarioStarted(scenarioDescription);
        if (method.isAnnotationPresent(CasesAsTable.class)) {
            this.currentScenarioModel.setCasesAsTable(true);
        }
        if (method.isAnnotationPresent(NotImplementedYet.class)) {
            this.currentScenarioModel.notImplementedYet = true;
        }
        if (this.currentScenarioCase.caseNr == 1) {
            this.addTags(method.getDeclaringClass().getAnnotations());
            this.addTags(method.getAnnotations());
        }
    }

    private void addTags(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            this.currentScenarioModel.tags.addAll(this.toTags(annotation));
        }
    }

    public List<Tag> toTags(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        IsTag isTag = annotationType.getAnnotation(IsTag.class);
        TagConfiguration tagConfig = isTag != null ? TagConfiguration.fromIsTag(isTag) : this.configuration.getTagConfiguration(annotationType);
        if (tagConfig == null) {
            return Collections.emptyList();
        }
        String type = annotationType.getSimpleName();
        if (!Strings.isNullOrEmpty((String)tagConfig.getType())) {
            type = tagConfig.getType();
        }
        Tag tag = new Tag(type);
        if (tagConfig.isPrependType()) {
            tag.setPrependType(true);
        }
        if (tagConfig.getDescription() != null) {
            tag.setDescription(tagConfig.getDescription());
        }
        if (!Strings.isNullOrEmpty((String)tagConfig.getDefaultValue())) {
            tag.setValue(tagConfig.getDefaultValue());
        }
        if (tagConfig.isIgnoreValue()) {
            return Arrays.asList(tag);
        }
        try {
            Method method = annotationType.getMethod("value", new Class[0]);
            Object value = method.invoke((Object)annotation, new Object[0]);
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    String[] stringArray = new String[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        stringArray[i] = array[i] + "";
                    }
                    if (tagConfig.isExplodeArray()) {
                        return ReportModelBuilder.getExplodedTags(tag, stringArray);
                    }
                    tag.setValue(stringArray);
                } else {
                    tag.setValue(value + "");
                }
            }
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (Exception e) {
            log.error("Error while getting 'value' method of annotation " + annotation, (Throwable)e);
        }
        return Arrays.asList(tag);
    }

    private static List<Tag> getExplodedTags(Tag originalTag, String[] stringArray) {
        ArrayList result = Lists.newArrayList();
        for (String singleValue : stringArray) {
            Tag newTag = new Tag(originalTag.getName(), singleValue);
            newTag.setDescription(originalTag.getDescription());
            newTag.setPrependType(originalTag.isPrependType());
            result.add(newTag);
        }
        return result;
    }

    @Override
    public void scenarioFinished() {
        AssertionUtil.assertTrue(this.scenarioStartedNanos > 0L, "Scenario has no start time");
        long durationInNanos = System.nanoTime() - this.scenarioStartedNanos;
        this.currentScenarioCase.setDurationInNanos(durationInNanos);
        this.currentScenarioModel.addDurationInNanos(durationInNanos);
    }

    public void setTestClass(Class<?> testClass) {
        this.setClassName(testClass.getName());
        if (testClass.isAnnotationPresent(Description.class)) {
            this.reportModel.setDescription(testClass.getAnnotation(Description.class).value());
        }
    }
}

