/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ExecutionStatusCalculator;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ScenarioCaseModel {
    public int caseNr;
    public List<StepModel> steps = Lists.newArrayList();
    private List<String> explicitArguments = Lists.newArrayList();
    private List<String> derivedArguments = Lists.newArrayList();
    public boolean success = true;
    public String errorMessage;
    public long durationInNanos;

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        for (StepModel step : this.steps) {
            step.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    public void addExplicitArguments(String ... args) {
        this.explicitArguments.addAll(Arrays.asList(args));
    }

    public void setExplicitArguments(List<String> arguments) {
        this.explicitArguments.clear();
        this.explicitArguments.addAll(arguments);
    }

    public List<String> getExplicitArguments() {
        return Collections.unmodifiableList(this.explicitArguments);
    }

    public void addStep(StepModel stepModel) {
        this.steps.add(stepModel);
    }

    public StepModel getStep(int i) {
        return this.steps.get(i);
    }

    public void setDurationInNanos(long durationInNanos) {
        this.durationInNanos = durationInNanos;
    }

    public long getDurationInNanos() {
        return this.durationInNanos;
    }

    public ExecutionStatus getExecutionStatus() {
        ExecutionStatusCalculator executionStatusCalculator = new ExecutionStatusCalculator();
        this.accept(executionStatusCalculator);
        return executionStatusCalculator.executionStatus();
    }

    public void addDerivedArguments(String ... values) {
        this.derivedArguments.addAll(Arrays.asList(values));
    }

    public List<String> getDerivedArguments() {
        return Collections.unmodifiableList(this.derivedArguments);
    }
}

