/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;

public class Tag {
    private final String name;
    private Object value;
    private String description;
    private boolean prependType;

    public Tag(String name) {
        this.name = name;
    }

    public Tag(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrependType() {
        return this.prependType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (!(value == null || value instanceof String || value.getClass().isArray() && value.getClass().getComponentType().isAssignableFrom(String.class))) {
            throw new IllegalArgumentException("value is neither null, String nor String[]");
        }
        this.value = value;
    }

    public Tag setPrependType(boolean prependType) {
        this.prependType = prependType;
        return this;
    }

    public String toString() {
        if (this.getValue() != null) {
            String valueString = this.getValueString();
            if (this.prependType) {
                return this.getName() + "-" + valueString;
            }
            return valueString;
        }
        return this.getName();
    }

    public String getValueString() {
        if (this.getValue() == null) {
            return null;
        }
        if (this.getValue().getClass().isArray()) {
            return Joiner.on((String)", ").join((Object[])((String[])this.getValue()));
        }
        return this.getValue().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getValue()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.getValue(), (Object)other.getValue());
    }
}

