/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.tngtech.jgiven.report.html.ScenarioHtmlWriter;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.io.PrintWriter;

public class DataTableScenarioHtmlWriter
extends ScenarioHtmlWriter {
    public DataTableScenarioHtmlWriter(PrintWriter writer) {
        super(writer);
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.caseNr == 1) {
            super.visit(scenarioCase);
        } else {
            this.scenarioCase = scenarioCase;
        }
    }

    @Override
    void printCaseHeader(ScenarioCaseModel scenarioCase) {
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.caseNr == 1) {
            this.writer.println("</ul>");
            this.writer.println("<h4>Cases:</h4>");
            this.writer.println("<table class='data-table'>");
            this.writer.println("<tr>");
            this.writer.print("<th>#</th>");
            for (String param : this.scenarioModel.getDerivedParameters()) {
                this.writer.print("<th>" + param + "</th>");
            }
            this.writer.print("<th>Status</th>");
            this.writer.println("</tr>");
        }
        this.writer.println("<tr>");
        this.writer.print("<td>" + scenarioCase.caseNr + "</td>");
        for (String arg : scenarioCase.getDerivedArguments()) {
            this.writer.print("<td>" + arg + "</td>");
        }
        this.writer.print("<td>");
        if (!scenarioCase.success) {
            this.writer.println("<div class='failed'>Failed: " + scenarioCase.errorMessage + "</div>");
        } else {
            this.writeStatusIcon(scenarioCase.getExecutionStatus());
        }
        this.utils.writeDuration(scenarioCase.durationInNanos);
        this.writer.print("</td>");
        this.writer.println("</tr>");
    }

    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        this.writer.println("</table>");
        super.visitEnd(scenarioModel);
    }

    @Override
    public void visit(StepModel stepModel) {
        if (this.scenarioCase.caseNr == 1) {
            super.visit(stepModel);
        }
    }

    @Override
    String formatCaseArgument(Word value) {
        String paramName = this.findParameterName(value);
        return "&lt;" + paramName + "&gt;";
    }

    private String findParameterName(Word word) {
        return word.getArgumentInfo().getParameterName();
    }
}

