/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.attachment;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.tngtech.jgiven.attachment.MediaType;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

public class Attachment {
    private String title;
    private final String content;
    private final MediaType mediaType;

    protected Attachment(String content, MediaType mediaType) {
        this(content, mediaType, null);
    }

    protected Attachment(String content, MediaType mediaType, String title) {
        if (mediaType == null) {
            throw new IllegalArgumentException("MediaType must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        this.content = content;
        this.mediaType = mediaType;
        this.title = title;
    }

    public String title() {
        return this.title;
    }

    public String content() {
        return this.content;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getTitle() {
        return this.title;
    }

    public Attachment withTitle(String title) {
        this.title = title;
        return this;
    }

    public static Attachment fromBinaryBytes(byte[] bytes, MediaType mediaType) {
        if (!mediaType.isBinary()) {
            throw new IllegalArgumentException("MediaType must be binary");
        }
        return new Attachment(DatatypeConverter.printBase64Binary((byte[])bytes), mediaType, null);
    }

    public static Attachment fromBinaryInputStream(InputStream inputStream, MediaType mediaType) throws IOException {
        return Attachment.fromBinaryBytes(ByteStreams.toByteArray((InputStream)inputStream), mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attachment fromBinaryFile(File file, MediaType mediaType) throws IOException {
        Attachment attachment;
        FileInputStream stream = new FileInputStream(file);
        try {
            attachment = Attachment.fromBinaryInputStream(stream, mediaType);
        }
        catch (Throwable throwable) {
            ResourceUtil.close(stream);
            throw throwable;
        }
        ResourceUtil.close(stream);
        return attachment;
    }

    public static Attachment fromTextFile(File file, MediaType mediaType, Charset charSet) throws IOException {
        return Attachment.fromText(Files.toString((File)file, (Charset)charSet), mediaType);
    }

    public static Attachment fromTextInputStream(InputStream inputStream, MediaType mediaType, Charset charset) throws IOException {
        return Attachment.fromText(CharStreams.toString((Readable)new InputStreamReader(inputStream, charset)), mediaType);
    }

    public static Attachment fromText(String content, MediaType mediaType) {
        if (mediaType.isBinary()) {
            throw new IllegalArgumentException("MediaType must not be binary");
        }
        return new Attachment(content, mediaType);
    }

    public static Attachment fromBase64(String base64encodedContent, MediaType mediaType) {
        if (!mediaType.isBinary()) {
            throw new IllegalArgumentException("MediaType must be binary");
        }
        return new Attachment(base64encodedContent, mediaType);
    }
}

