/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.tngtech.jgiven.impl.ScenarioExecutor;
import com.tngtech.jgiven.integration.CanWire;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelBuilder;

public class ScenarioBase {
    protected final ScenarioExecutor executor = new ScenarioExecutor();
    protected final ReportModelBuilder modelBuilder = new ReportModelBuilder();

    public ScenarioBase() {
        this.executor.setListener(this.modelBuilder);
    }

    public void setModel(ReportModel scenarioCollectionModel) {
        this.modelBuilder.setReportModel(scenarioCollectionModel);
    }

    public ReportModel getModel() {
        return this.modelBuilder.getScenarioCollectionModel();
    }

    public <T> T addStage(Class<T> stepsClass) {
        return this.executor.addStage(stepsClass);
    }

    public void finished() throws Throwable {
        this.executor.finished();
    }

    public ScenarioExecutor getExecutor() {
        return this.executor;
    }

    public void wireSteps(CanWire canWire) {
        this.executor.wireSteps(canWire);
    }

    public ReportModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public ScenarioBase startScenario(String description) {
        this.executor.startScenario(description);
        return this;
    }
}

