/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.PrintWriterUtil;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.impl.util.Version;
import com.tngtech.jgiven.report.html.DataTableScenarioHtmlWriter;
import com.tngtech.jgiven.report.html.HtmlTocWriter;
import com.tngtech.jgiven.report.html.HtmlWriterUtils;
import com.tngtech.jgiven.report.html.MultiCaseScenarioHtmlWriter;
import com.tngtech.jgiven.report.html.ScenarioHtmlWriter;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ReportStatistics;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StatisticsCalculator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class ReportModelHtmlWriter
extends ReportModelVisitor {
    protected final PrintWriter writer;
    protected final HtmlWriterUtils utils;
    private ReportStatistics statistics;

    public ReportModelHtmlWriter(PrintWriter writer) {
        this.writer = writer;
        this.utils = new HtmlWriterUtils(writer);
    }

    public void writeHtmlHeader(String title) {
        this.utils.writeHtmlHeader(title);
        this.writer.write("<div id='page'>");
    }

    public void writeHtmlFooter() {
        this.writer.println("</div> <!-- col-container -->");
        this.writer.println("<div id='page-footer'></div>");
        this.writer.println("</div> <!-- page -->");
        this.writeJGivenFooter();
        this.writer.println("<script src='report.js'></script>");
        this.writer.println("</body></html>");
    }

    private void writeJGivenFooter() {
        this.writer.print("<div id='footer'>Generated by <a href='http://jgiven.org'>JGiven</a> ");
        this.writer.print(Version.VERSION);
        this.writer.print(" - on " + DateFormat.getDateTimeInstance().format(new Date()));
        this.closeDiv();
    }

    private void closeDiv() {
        this.writer.println("</div>");
    }

    public void write(ScenarioModel model) {
        this.writeHtmlHeader(model.getClassName());
        model.accept(this);
        this.writeHtmlFooter();
    }

    public void write(ReportModel model, HtmlTocWriter htmlTocWriter) {
        this.writeHtmlHeader(model.getClassName());
        if (htmlTocWriter != null) {
            htmlTocWriter.writeToc(this.writer);
        }
        model.accept(this);
        this.writeHtmlFooter();
    }

    private void writeStatistics(ReportModel model) {
        if (!model.getScenarios().isEmpty()) {
            this.statistics = new StatisticsCalculator().getStatistics(model);
            this.writer.print("<div class='statistics'>");
            this.writer.print(this.statistics.numScenarios + " scenarios, " + this.statistics.numCases + " cases, " + this.statistics.numSteps + " steps, " + this.statistics.numFailedCases + " failed cases ");
            this.utils.writeDuration(this.statistics.durationInNanos);
            this.closeDiv();
        }
    }

    ReportStatistics getStatistics() {
        return this.statistics;
    }

    public static String toString(final ScenarioModel model) {
        return ReportModelHtmlWriter.toString(new Function<PrintWriter, Void>(){

            public Void apply(PrintWriter input) {
                new ReportModelHtmlWriter(input).write(model);
                return null;
            }
        });
    }

    public static String toString(final ReportModel model) {
        return ReportModelHtmlWriter.toString(new Function<PrintWriter, Void>(){

            public Void apply(PrintWriter input) {
                new ReportModelHtmlWriter(input).write(model, null);
                return null;
            }
        });
    }

    public static String toString(Function<PrintWriter, Void> writeFunction) {
        String string;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8.name()), false);
            writeFunction.apply((Object)printWriter);
            printWriter.flush();
            string = stream.toString(Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                ResourceUtil.close(printWriter);
                throw throwable;
            }
        }
        ResourceUtil.close(printWriter);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, ReportModel model, HtmlTocWriter htmlTocWriter) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter printWriter = new PrintWriter(file, Charsets.UTF_8.name());
        try {
            new ReportModelHtmlWriter(printWriter).write(model, htmlTocWriter);
            printWriter.flush();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }

    @Override
    public void visit(ReportModel reportModel) {
        this.writer.println("<div id='rightpane'>");
        this.writeHeader(reportModel);
        this.writer.println("<div id='content'>");
        if (!reportModel.getScenarios().isEmpty()) {
            this.writer.println("<input class='search-input' id='content-search-input' size='30' placeholder='enter regexp to search in scenarios' onkeydown='contentSearchChanged(event)'></input>");
            this.writer.println("<i class='icon-plus-squared-alt' id='expand-all-icon' title='Expand All' onclick='expandAllClicked()'></i>");
            this.writer.println("<i class='icon-minus-squared-alt' id='collapse-all-icon' title='Collapse All' onclick='collapseAllClicked()'></i>");
        }
    }

    void writeHeader(ReportModel reportModel) {
        this.writer.println("<div id='header'>");
        this.writer.println("<div id='header-title'>");
        this.writer.println("<i id='show-menu-icon' class='icon-menu collapsed' onclick='showToc()'></i>");
        String packageName = "";
        String className = reportModel.getClassName();
        if (reportModel.getClassName().contains(".")) {
            packageName = Files.getNameWithoutExtension((String)reportModel.getClassName());
            className = Files.getFileExtension((String)reportModel.getClassName());
        }
        this.writer.println(String.format("<div class='packagename'>%s</div>", packageName));
        this.writer.println(String.format("<h2>%s</h2>", className));
        this.writer.println("</div> <!-- #header-title -->");
        if (!Strings.isNullOrEmpty((String)reportModel.getDescription())) {
            this.writer.println(String.format("<div class='description'>%s</div>", reportModel.getDescription()));
        }
        this.closeDiv();
    }

    @Override
    public void visitEnd(ReportModel reportModel) {
        this.writeStatistics(reportModel);
        this.writer.println("</div> <!-- testcase-content -->");
        this.writer.println("</div> <!-- testcase -->");
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        ScenarioHtmlWriter scenarioHtmlWriter = scenarioModel.isCasesAsTable() ? new DataTableScenarioHtmlWriter(this.writer) : new MultiCaseScenarioHtmlWriter(this.writer);
        scenarioModel.accept(scenarioHtmlWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReportModelHtmlWriter writeModelToFile(ReportModel model, HtmlTocWriter tocWriter, File file) {
        ReportModelHtmlWriter reportModelHtmlWriter;
        PrintWriter printWriter = PrintWriterUtil.getPrintWriter(file);
        try {
            ReportModelHtmlWriter htmlWriter = new ReportModelHtmlWriter(printWriter);
            htmlWriter.write(model, tocWriter);
            reportModelHtmlWriter = htmlWriter;
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
        return reportModelHtmlWriter;
    }
}

