/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;

final class ExecutionStatusCalculator
extends ReportModelVisitor {
    private int failedCount;
    private int notImplementedCount;
    private int totalCount;
    private ExecutionStatus status;

    ExecutionStatusCalculator() {
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        if (scenarioModel.isNotImplementedYet()) {
            this.status = ExecutionStatus.NONE_IMPLEMENTED;
        }
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        if (!scenarioCase.success) {
            this.status = ExecutionStatus.FAILED;
        }
    }

    @Override
    public void visit(StepModel stepModel) {
        if (stepModel.isFailed()) {
            ++this.failedCount;
        } else if (stepModel.isNotImplementedYet()) {
            ++this.notImplementedCount;
        }
        ++this.totalCount;
    }

    public ExecutionStatus executionStatus() {
        if (this.status != null) {
            return this.status;
        }
        if (this.failedCount > 0) {
            return ExecutionStatus.FAILED;
        }
        if (this.notImplementedCount > 0) {
            if (this.notImplementedCount < this.totalCount) {
                return ExecutionStatus.PARTIALLY_IMPLEMENTED;
            }
            return ExecutionStatus.NONE_IMPLEMENTED;
        }
        return ExecutionStatus.SUCCESS;
    }
}

