/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.analysis;

import com.tngtech.jgiven.report.analysis.CaseArgumentAnalyser;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CaseDifferenceAnalyzer {
    public void analyze(ScenarioModel scenarioModel) {
        if (scenarioModel.getScenarioCases().size() < 2) {
            return;
        }
        CaseArgumentAnalyser.CollectPhase collectPhase = new CaseArgumentAnalyser.CollectPhase(scenarioModel);
        scenarioModel.accept(collectPhase);
        List<Sequence> commonSequences = CaseDifferenceAnalyzer.findCommonSequence(collectPhase.allWords);
        for (Sequence seq : commonSequences) {
            seq.setDifferenceToWords();
        }
    }

    private static List<Sequence> findCommonSequence(List<List<Word>> input) {
        Searcher searcher;
        int[] nextMatching;
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        for (List<Word> s : input) {
            Sequence seq = new Sequence();
            seq.input = s;
            result.add(seq);
        }
        int[] startIndices = new int[input.size()];
        while (!CaseDifferenceAnalyzer.someAtEnd(result) && (nextMatching = (searcher = new Searcher(input, startIndices)).findNextMatching()) != null) {
            for (int i = 0; i < result.size(); ++i) {
                ((Sequence)result.get((int)i)).elements.add(nextMatching[i]);
            }
            startIndices = CaseDifferenceAnalyzer.incAllByOne(nextMatching);
        }
        return result;
    }

    private static int[] incAllByOne(int[] matching) {
        int[] result = new int[matching.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = matching[i] + 1;
        }
        return result;
    }

    private static boolean someAtEnd(List<Sequence> result) {
        for (Sequence s : result) {
            if (!s.isAtEnd()) continue;
            return true;
        }
        return false;
    }

    static class Searcher {
        List<List<Word>> input;
        int[] currentIndices;
        int currentRow;
        Word value;
        int[] startIndices;

        Searcher(List<List<Word>> input, int[] startIndices) {
            this.input = input;
            this.startIndices = startIndices;
            this.currentIndices = Arrays.copyOf(startIndices, startIndices.length);
            this.initSearch();
        }

        private void initSearch() {
            this.value = this.input.get(0).get(this.currentIndices[0]);
            this.currentRow = 1;
        }

        public int[] findNextMatching() {
            return this.findNext();
        }

        private int[] findNext() {
            while (this.currentRow < this.input.size()) {
                if (this.currentRowAtEnd()) {
                    if (this.backTrack()) continue;
                    return null;
                }
                if (this.getCurrentValue().equals(this.value)) {
                    ++this.currentRow;
                    continue;
                }
                this.currentIndices[this.currentRow] = this.getCurrentIndex() + 1;
            }
            return this.currentIndices;
        }

        private boolean backTrack() {
            if (this.currentRow == 0) {
                this.currentIndices[this.currentRow] = this.getCurrentIndex() + 1;
                if (this.currentRowAtEnd()) {
                    return false;
                }
                this.value = this.getCurrentValue();
                ++this.currentRow;
                return true;
            }
            this.currentIndices[this.currentRow] = this.startIndices[this.currentRow];
            --this.currentRow;
            return this.backTrack();
        }

        private Word getCurrentValue() {
            return this.input.get(this.currentRow).get(this.getCurrentIndex());
        }

        private int getCurrentIndex() {
            return this.currentIndices[this.currentRow];
        }

        private boolean currentRowAtEnd() {
            return this.getCurrentIndex() == this.input.get(this.currentRow).size();
        }
    }

    static class Sequence {
        List<Word> input;
        List<Integer> elements = new ArrayList<Integer>();

        Sequence() {
        }

        int getLastIndex() {
            return this.elements.get(this.elements.size() - 1);
        }

        boolean isAtEnd() {
            if (this.elements.isEmpty()) {
                return this.input.isEmpty();
            }
            return this.getLastIndex() == this.input.size() - 1;
        }

        public void setDifferenceToWords() {
            for (Word word : this.input) {
                word.setIsDifferent(true);
            }
            for (Integer i : this.elements) {
                this.input.get(i).setIsDifferent(false);
            }
        }
    }
}

