/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.attachment;

public class MediaType {
    public static final MediaType PNG = MediaType.image("png");
    public static final MediaType PLAIN_TEXT = MediaType.text("plain");
    private final Type type;
    private final String subType;
    private final boolean binary;

    public MediaType(Type type, String subType, boolean binary) {
        this.type = type;
        this.subType = subType;
        this.binary = binary;
    }

    public Type getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String asString() {
        return this.type.value + "/" + this.subType;
    }

    public static MediaType image(String subType) {
        return new MediaType(Type.IMAGE, subType, true);
    }

    public static MediaType video(String subType) {
        return new MediaType(Type.VIDEO, subType, true);
    }

    public static MediaType audio(String subType) {
        return new MediaType(Type.AUDIO, subType, true);
    }

    public static MediaType text(String subType) {
        return new MediaType(Type.TEXT, subType, false);
    }

    public static enum Type {
        APPLICATION("application"),
        AUDIO("audio"),
        IMAGE("image"),
        TEXT("text"),
        VIDEO("video");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Type fromString(String string) {
            for (Type type : Type.values()) {
                if (!type.value.equalsIgnoreCase(string)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown type " + string);
        }
    }
}

