/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.fusesource.jansi.AnsiConsole;

public class PrintWriterUtil {
    public static PrintWriter getPrintWriter(File file) {
        try {
            return new PrintWriter(file, Charsets.UTF_8.name());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static PrintWriter getPrintWriter(OutputStream outputStream, boolean withColor) {
        if (withColor) {
            outputStream = AnsiConsole.wrapOutputStream((OutputStream)outputStream);
        }
        try {
            return new PrintWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

