/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.tngtech.jgiven.report.util.DurationFormatter;
import java.io.PrintWriter;

public class HtmlWriterUtils {
    private final PrintWriter writer;

    public HtmlWriterUtils(PrintWriter writer) {
        this.writer = writer;
    }

    public void writeHtmlHeader(String title) {
        this.writer.println("<!DOCTYPE html>");
        this.writer.println("<html><head>");
        this.writer.println("  <meta charset='utf-8'>");
        this.writer.println(String.format("  <title>%s</title>", title));
        this.writer.println("  <link href='style.css' rel='stylesheet'>");
        this.writer.println("</head>");
        this.writer.println("<body>");
    }

    public void writeHtmlFooter() {
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    public void writeDuration(long durationInNanos) {
        this.writer.print(" <span class='duration'>(" + DurationFormatter.format(durationInNanos) + ")</span>");
    }
}

