/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.html.HtmlTocWriter;
import com.tngtech.jgiven.report.html.PackageTocBuilder;
import com.tngtech.jgiven.report.html.ReportModelHtmlWriter;
import com.tngtech.jgiven.report.html.StatisticsPageHtmlWriter;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.Tag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHtmlReportGenerator
extends AbstractReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(StaticHtmlReportGenerator.class);

    @Override
    public void generate() {
        this.writeEnd();
        this.copyFileToTargetDir("style.css");
        this.copyFileToTargetDir("default.css");
        this.copyFileToTargetDir("print.css");
        this.copyFileToTargetDir("report.js");
        this.copyFileToTargetDir("fontawesome.css");
        this.copyFileToTargetDir("fontawesome.ttf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void copyFileToTargetDir(String fileName) {
        InputStream stream = null;
        FileOutputStream fileOutputStream = null;
        try {
            stream = this.getClass().getResourceAsStream("/com/tngtech/jgiven/report/html/" + fileName);
            File file = new File(this.targetDirectory, fileName);
            fileOutputStream = new FileOutputStream(file);
            ByteStreams.copy((InputStream)stream, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            ResourceUtil.close(stream, fileOutputStream);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    ResourceUtil.close(stream, fileOutputStream);
                    throw throwable;
                }
            }
            ResourceUtil.close(stream, fileOutputStream);
        }
        ResourceUtil.close(stream, fileOutputStream);
    }

    public void writeEnd() {
        PackageTocBuilder.PackageToc packageToc = new PackageTocBuilder(this.completeReportModel.getAllReportModels()).getRootPackageToc();
        HtmlTocWriter tocWriter = new HtmlTocWriter(this.completeReportModel, packageToc);
        for (ReportModelFile modelFile : this.completeReportModel.getAllReportModels()) {
            String targetFileName = Files.getNameWithoutExtension((String)modelFile.file.getName()) + ".html";
            File targetFile = new File(this.targetDirectory, targetFileName);
            ReportModelHtmlWriter modelWriter = ReportModelHtmlWriter.writeModelToFile(modelFile.model, tocWriter, targetFile);
        }
        this.writeTagFiles(tocWriter);
        this.writeScenarios(tocWriter, this.completeReportModel.getFailedScenarios(), "Failed Scenarios", "failed.html");
        this.writeScenarios(tocWriter, this.completeReportModel.getPendingScenarios(), "Pending Scenarios", "pending.html");
        this.writeScenarios(tocWriter, this.completeReportModel.getAllScenarios(), "All Scenarios", "all.html");
        StatisticsPageHtmlWriter statisticsPageHtmlWriter = new StatisticsPageHtmlWriter(tocWriter, this.completeReportModel.getTotalStatistics());
        statisticsPageHtmlWriter.write(this.targetDirectory);
    }

    private void writeScenarios(HtmlTocWriter tocWriter, List<ScenarioModel> failedScenarios, String name, String fileName) {
        ReportModel completeReportModel = new ReportModel();
        completeReportModel.setScenarios(failedScenarios);
        completeReportModel.setClassName(name);
        ReportModelHtmlWriter.writeModelToFile(completeReportModel, tocWriter, new File(this.targetDirectory, fileName));
    }

    private void writeTagFiles(HtmlTocWriter tocWriter) {
        for (Tag tag : this.completeReportModel.getAllTags()) {
            this.writeTagFile(tag, this.completeReportModel.getScenariosByTag(tag), tocWriter);
        }
    }

    private void writeTagFile(Tag tag, List<ScenarioModel> value, HtmlTocWriter tocWriter) {
        try {
            ReportModel completeReportModel = new ReportModel();
            completeReportModel.setClassName(tag.getName());
            if (tag.getValues().isEmpty()) {
                completeReportModel.setClassName(completeReportModel.getClassName() + "." + tag.getValueString());
            }
            completeReportModel.setScenarios(value);
            completeReportModel.setDescription(tag.getDescription());
            String fileName = HtmlTocWriter.tagToFilename(tag);
            File targetFile = new File(this.targetDirectory, fileName);
            ReportModelHtmlWriter.writeToFile(targetFile, completeReportModel, tocWriter);
        }
        catch (Exception e) {
            log.error("Error while trying to write HTML file for tag " + tag.getName());
        }
    }
}

