/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Tag {
    private final String name;
    private Object value;
    private String description;
    private Boolean prependType;
    private String color;
    private String cssClass;

    public Tag(String name) {
        this.name = name;
    }

    public Tag(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrependType() {
        return this.prependType != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getCssClassOrDefault() {
        return this.cssClass == null ? "tag-" + this.getName() : this.cssClass;
    }

    public List<String> getValues() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        if (this.value instanceof String) {
            return Lists.newArrayList((Object[])new String[]{(String)this.value});
        }
        return (List)this.value;
    }

    public void setValue(List<String> values) {
        this.value = values;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Tag setPrependType(boolean prependType) {
        this.prependType = prependType ? Boolean.valueOf(true) : null;
        return this;
    }

    public String toString() {
        if (this.value != null) {
            String valueString = this.getValueString();
            if (this.isPrependType()) {
                return this.getName() + "-" + valueString;
            }
            return valueString;
        }
        return this.getName();
    }

    public String getValueString() {
        if (this.value == null) {
            return null;
        }
        return Joiner.on((String)", ").join(this.getValues());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.value, (Object)other.value);
    }

    public String toEscapedString() {
        ArrayList parts = Lists.newArrayList((Object[])new String[]{this.getName()});
        parts.addAll(this.getValues());
        String escapedString = Tag.escape(Joiner.on((char)'-').join((Iterable)parts));
        return escapedString.substring(0, Math.min(escapedString.length(), 255));
    }

    static String escape(String string) {
        return string.replaceAll("[^\\p{Alnum}-]", "_");
    }
}

