/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import com.tngtech.jgiven.report.text.PlainTextScenarioWriter;
import com.tngtech.jgiven.report.text.PlainTextTableWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class DataTablePlainTextScenarioWriter
extends PlainTextScenarioWriter {
    public DataTablePlainTextScenarioWriter(PrintWriter writer, boolean withColor) {
        super(writer, withColor);
    }

    @Override
    public void visit(StepModel stepModel) {
        if (this.currentCaseModel.getCaseNr() > 1) {
            return;
        }
        super.visit(stepModel);
    }

    @Override
    protected String wordToString(Word word) {
        if (word.isArg() && word.getArgumentInfo().isParameter()) {
            String parameterName = word.getArgumentInfo().getParameterName();
            return "<" + parameterName + ">";
        }
        return super.wordToString(word);
    }

    @Override
    protected void printCaseLine(ScenarioCaseModel scenarioCase) {
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.getCaseNr() == 1) {
            super.visitEnd(scenarioCase);
        }
    }

    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        this.writer.println("  Cases:\n");
        DataTable dataTableModel = this.getDataTableModel(scenarioModel);
        PlainTextTableWriter dataTableWriter = new PlainTextTableWriter(this.writer, this.withColor);
        String caseIndent = "    ";
        dataTableWriter.writeDataTable(dataTableModel, caseIndent);
    }

    private DataTable getDataTableModel(ScenarioModel scenarioModel) {
        ArrayList result = Lists.newArrayList();
        ArrayList headerRow = Lists.newArrayList();
        headerRow.add("#");
        headerRow.addAll(scenarioModel.getDerivedParameters());
        headerRow.add("Status");
        result.add(headerRow);
        int i = 1;
        for (ScenarioCaseModel c : scenarioModel.getScenarioCases()) {
            ArrayList row = Lists.newArrayList();
            row.add("" + i++);
            row.addAll(c.getDerivedArguments());
            row.add(this.getStatusText(c));
            result.add(row);
        }
        return new DataTable(Table.HeaderType.HORIZONTAL, result);
    }

    private String getStatusText(ScenarioCaseModel c) {
        if (c.success) {
            return "Success";
        }
        return "Failed: " + c.errorMessage;
    }
}

