/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.util.List;

public class PlainTextTableWriter
extends PlainTextWriter {
    public PlainTextTableWriter(PrintWriter printWriter, boolean withColor) {
        super(printWriter, withColor);
    }

    public void writeDataTable(DataTable dataTable, String indent) {
        StringBuilder formatBuilder = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        List<List<String>> tableModel = dataTable.getData();
        List<ColumnSpec> columnWidths = this.getColumnSpecs(tableModel);
        for (ColumnSpec spec : columnWidths) {
            formatBuilder.append("| %");
            if (spec.leftAligned) {
                formatBuilder.append("-");
            }
            formatBuilder.append(spec.width + "s ");
            lineBuilder.append("+");
            lineBuilder.append(Strings.repeat((String)"-", (int)(spec.width + 2)));
        }
        formatBuilder.append("|");
        lineBuilder.append("+");
        String formatString = formatBuilder.toString();
        this.writer.println(indent + String.format(formatString, tableModel.get(0).toArray()));
        if (dataTable.getHeaderType().isHorizontal()) {
            this.writer.println(indent + lineBuilder);
        }
        for (int nrow = 1; nrow < tableModel.size(); ++nrow) {
            this.writer.println(indent + String.format(formatString, tableModel.get(nrow).toArray()));
        }
    }

    private List<ColumnSpec> getColumnSpecs(List<List<String>> dataTableModel) {
        Object[] result = new ColumnSpec[dataTableModel.get(0).size()];
        for (int nrow = 0; nrow < dataTableModel.size(); ++nrow) {
            List<String> row = dataTableModel.get(nrow);
            for (int ncol = 0; ncol < row.size(); ++ncol) {
                String value = row.get(ncol);
                int width = value.length();
                Object spec = result[ncol];
                if (spec == null) {
                    result[ncol] = spec = new ColumnSpec();
                }
                if (width > ((ColumnSpec)spec).width) {
                    ((ColumnSpec)spec).width = width;
                }
                if (nrow <= 0 || Doubles.tryParse((String)value) != null) continue;
                ((ColumnSpec)spec).leftAligned = true;
            }
        }
        return Lists.newArrayList((Object[])result);
    }

    static class ColumnSpec {
        int width;
        boolean leftAligned;

        ColumnSpec() {
        }
    }
}

