/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.attachment;

import com.tngtech.jgiven.impl.util.ApiUtil;
import java.nio.charset.Charset;

public class MediaType {
    private static final Charset UTF_8 = Charset.forName("utf8");
    public static final MediaType GIF = MediaType.image("gif");
    public static final MediaType PNG = MediaType.image("png");
    public static final MediaType JPEG = MediaType.image("jpeg");
    public static final MediaType SVG_UTF_8 = MediaType.imageUtf8("svg+xml");
    @Deprecated
    public static final MediaType PLAIN_TEXT = MediaType.text("plain");
    public static final MediaType PLAIN_TEXT_UTF_8 = MediaType.textUtf8("plain");
    public static final MediaType JSON_UTF_8 = MediaType.applicationUtf8("json");
    public static final MediaType APPLICATION_XML_UTF_8 = MediaType.applicationUtf8("xml");
    public static final MediaType XML_UTF_8 = MediaType.textUtf8("xml");
    private final Type type;
    private final String subType;
    private final boolean binary;
    private final Charset charset;

    @Deprecated
    public MediaType(Type type, String subType, boolean binary) {
        this.type = ApiUtil.notNull(type, "type must not be null");
        this.subType = ApiUtil.notNull(subType, "subType must not be null");
        this.binary = binary;
        this.charset = null;
    }

    private MediaType(Type type, String subType, Charset charset) {
        this.type = ApiUtil.notNull(type, "type must not be null");
        this.subType = ApiUtil.notNull(subType, "subType must not be null");
        this.charset = ApiUtil.notNull(charset, "charset must not be null");
        this.binary = false;
    }

    public Type getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isImage() {
        return this.type == Type.IMAGE;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            throw new IllegalArgumentException("No charset is specified for media type " + this);
        }
        return this.charset;
    }

    public String asString() {
        return this.type.value + "/" + this.subType;
    }

    public static MediaType binary(Type type, String subType) {
        return new MediaType(type, subType, true);
    }

    public static MediaType nonBinary(Type type, String subType, Charset charSet) {
        ApiUtil.notNull(charSet, "charset must not be null");
        return new MediaType(type, subType, charSet);
    }

    public static MediaType nonBinaryUtf8(Type type, String subType) {
        return new MediaType(type, subType, UTF_8);
    }

    public static MediaType image(String subType) {
        return MediaType.binary(Type.IMAGE, subType);
    }

    public static MediaType imageUtf8(String subType) {
        return MediaType.nonBinaryUtf8(Type.IMAGE, subType);
    }

    public static MediaType application(String subType) {
        return MediaType.binary(Type.APPLICATION, subType);
    }

    public static MediaType applicationUtf8(String subType) {
        return MediaType.nonBinaryUtf8(Type.APPLICATION, subType);
    }

    public static MediaType video(String subType) {
        return MediaType.binary(Type.VIDEO, subType);
    }

    public static MediaType audio(String subType) {
        return MediaType.binary(Type.AUDIO, subType);
    }

    @Deprecated
    public static MediaType text(String subType) {
        return new MediaType(Type.TEXT, subType, false);
    }

    public static MediaType text(String subType, Charset charset) {
        return MediaType.nonBinary(Type.TEXT, subType, charset);
    }

    public static MediaType textUtf8(String subType) {
        return MediaType.text(subType, UTF_8);
    }

    public static enum Type {
        APPLICATION("application"),
        AUDIO("audio"),
        IMAGE("image"),
        TEXT("text"),
        VIDEO("video");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Type fromString(String string) {
            for (Type type : Type.values()) {
                if (!type.value.equalsIgnoreCase(string)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown type " + string);
        }
    }
}

