/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report;

import com.google.common.io.Files;
import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.exception.JGivenInternalDefectException;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportGenerator;
import com.tngtech.jgiven.report.json.ReportModelReader;
import com.tngtech.jgiven.report.model.CompleteReportModel;
import com.tngtech.jgiven.report.text.PlainTextReportGenerator;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportGenerator.class);
    private File sourceDirectory = new File(".");
    private File targetDirectory = new File(".");
    private File customCssFile = null;
    private Format format = Format.HTML;

    public static void main(String ... args) throws Exception {
        ReportGenerator generator = new ReportGenerator();
        ReportGenerator.parseArgs(generator, args);
        generator.generate();
    }

    static void parseArgs(ReportGenerator generator, String ... args) {
        for (String arg : args) {
            if (arg.equals("-h") || arg.equals("--help")) {
                ReportGenerator.printUsageAndExit();
                continue;
            }
            if (arg.startsWith("--dir=") || arg.startsWith("--sourceDir=")) {
                generator.setSourceDirectory(new File(arg.split("=")[1]));
                if (!arg.startsWith("--dir=")) continue;
                System.err.println("DEPRECATION WARNING: --dir is deprecated, please use --sourceDir instead");
                continue;
            }
            if (arg.startsWith("--todir=") || arg.startsWith("--targetDir=")) {
                generator.setTargetDirectory(new File(arg.split("=")[1]));
                if (!arg.startsWith("--todir=")) continue;
                System.err.println("DEPRECATION WARNING: --todir is deprecated, please use--targetDir instead");
                continue;
            }
            if (arg.startsWith("--customcss=")) {
                generator.setCustomCssFile(new File(arg.split("=")[1]));
                continue;
            }
            if (arg.startsWith("--format=")) {
                String formatArg = arg.split("=")[1];
                Format format = Format.fromStringOrNull(formatArg);
                if (format == null) {
                    System.err.println("Illegal argument for --format: " + formatArg);
                    ReportGenerator.printUsageAndExit();
                }
                generator.setFormat(format);
                continue;
            }
            ReportGenerator.printUsageAndExit();
        }
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void generate() throws Exception {
        if (!this.getTargetDirectory().exists() && !this.getTargetDirectory().mkdirs()) {
            log.error("Could not create target directory " + this.getTargetDirectory());
            return;
        }
        CompleteReportModel reportModel = new ReportModelReader().readDirectory(this.getSourceDirectory());
        if (this.format == Format.HTML5 || this.format == Format.HTML) {
            this.generateHtml5Report(reportModel);
        } else if (this.format == Format.TEXT) {
            new PlainTextReportGenerator().generate(reportModel, this.getTargetDirectory());
        } else if (this.format == Format.ASCIIDOC) {
            new AsciiDocReportGenerator().generate(reportModel, this.getTargetDirectory());
        }
    }

    private void copyCustomCssFile(File targetDirectory) throws IOException {
        if (this.getCustomCssFile() != null) {
            if (!this.getCustomCssFile().canRead()) {
                log.info("Cannot read customCssFile " + this.getCustomCssFile() + " skipping");
            } else {
                Files.copy((File)this.getCustomCssFile(), (File)new File(targetDirectory, "custom.css"));
            }
        }
    }

    private void generateHtml5Report(CompleteReportModel reportModel) throws IOException {
        AbstractReportGenerator reportGenerator;
        try {
            Class<?> aClass = this.getClass().getClassLoader().loadClass("com.tngtech.jgiven.report.html5.Html5ReportGenerator");
            reportGenerator = (AbstractReportGenerator)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JGivenInstallationException("The JGiven HTML5 Report Generator seems not to be on the classpath.\nEnsure that you have a dependency to jgiven-html5-report.");
        }
        catch (Exception e) {
            throw new JGivenInternalDefectException("The HTML5 Report Generator could not be instantiated.", e);
        }
        reportGenerator.generate(reportModel, this.getTargetDirectory());
        this.copyCustomCssFile(new File(this.getTargetDirectory(), "css"));
    }

    private static void printUsageAndExit() {
        System.err.println("Options: [--format=<format>] [--sourceDir=<dir>] [--targetDir=<dir>] [--customcss=<cssfile>]");
        System.err.println("  <format> = html or text, default is html");
        System.exit(1);
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public File getCustomCssFile() {
        return this.customCssFile;
    }

    public void setCustomCssFile(File customCssFile) {
        this.customCssFile = customCssFile;
    }

    public static enum Format {
        HTML("html"),
        TEXT("text"),
        ASCIIDOC("asciidoc"),
        HTML5("html5");

        private final String text;

        private Format(String text) {
            this.text = text;
        }

        public static Format fromStringOrNull(String value) {
            for (Format format : Format.values()) {
                if (!format.text.equalsIgnoreCase(value)) continue;
                return format;
            }
            return null;
        }
    }
}

