/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.asciidoc;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.PrintWriterUtil;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.AbstractReportGenerator;
import com.tngtech.jgiven.report.AbstractReportModelHandler;
import com.tngtech.jgiven.report.ReportModelHandler;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;

public class AsciiDocReportGenerator
extends AbstractReportGenerator {
    private List<String> allFiles = Lists.newArrayList();

    @Override
    public void generate() {
        for (ReportModelFile reportModelFile : this.completeReportModel.getAllReportModels()) {
            this.writeReportModelToFile(reportModelFile.model, reportModelFile.file);
        }
        this.generateIndexFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReportModelToFile(ReportModel model, File file) {
        String targetFileName = Files.getNameWithoutExtension((String)file.getName()) + ".asciidoc";
        this.allFiles.add(targetFileName);
        File targetFile = new File(this.targetDirectory, targetFileName);
        PrintWriter printWriter = PrintWriterUtil.getPrintWriter(targetFile);
        try {
            new AbstractReportModelHandler().handle(model, new AsciiDocReportModelVisitor(printWriter));
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateIndexFile() {
        PrintWriter printWriter = PrintWriterUtil.getPrintWriter(new File(this.targetDirectory, "index.asciidoc"));
        try {
            printWriter.println("= JGiven Documentation =\n");
            printWriter.println(":toc: left\n");
            printWriter.println("== Scenarios ==\n");
            printWriter.println("=== Classes ===\n");
            printWriter.println("include::allClasses.asciidoc[]");
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
        printWriter = PrintWriterUtil.getPrintWriter(new File(this.targetDirectory, "allClasses.asciidoc"));
        try {
            for (String fileName : this.allFiles) {
                printWriter.println("include::" + fileName + "[]\n");
            }
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }

    class AsciiDocReportModelVisitor
    implements ReportModelHandler {
        private final PrintWriter writer;
        private boolean literalBlock;

        public AsciiDocReportModelVisitor(PrintWriter printWriter) {
            this.writer = printWriter;
        }

        @Override
        public void className(String className) {
            this.writer.println("==== " + className + " ====\n");
        }

        @Override
        public void reportDescription(String description) {
            this.writer.println(description);
            this.writer.println();
        }

        @Override
        public void scenarioTitle(String title) {
            this.writer.println("===== " + WordUtil.capitalize(title) + " =====\n");
        }

        @Override
        public void caseHeader(int caseNr, List<String> parameterNames, List<String> caseArguments) {
            this.writer.print("====== Case " + caseNr + ": ");
            for (int i = 0; i < parameterNames.size(); ++i) {
                this.writer.print(parameterNames.get(i) + " = " + caseArguments.get(i));
            }
            this.writer.println(" ======\n");
        }

        @Override
        public void dataTable(AbstractReportModelHandler.ScenarioDataTable scenarioDataTable) {
            this.writer.println("\n.Cases");
            this.writer.println("[options=\"header\"]");
            this.writer.println("|===");
            this.writer.print("| # ");
            for (String placeHolder : scenarioDataTable.placeHolders()) {
                this.writer.print(" | " + placeHolder);
            }
            this.writer.println(" | Status");
            for (AbstractReportModelHandler.ScenarioDataTable.Row row : scenarioDataTable.rows()) {
                this.writer.print("| " + row.nr());
                for (String value : row.arguments()) {
                    this.writer.print(" | " + this.escapeTableValue(value));
                }
                this.writer.println(" | " + (Object)((Object)row.status()));
            }
            this.writer.println("|===");
        }

        @Override
        public void scenarioEnd() {
            this.writer.println();
        }

        @Override
        public void stepStart() {
            this.literalBlock = false;
        }

        @Override
        public void stepEnd() {
            if (!this.literalBlock) {
                this.writer.println("+");
            }
        }

        @Override
        public void introWord(String value) {
            this.writer.print(value + " ");
            this.literalBlock = false;
        }

        @Override
        public void stepArgumentPlaceHolder(String placeHolderValue) {
            this.writer.print("*<" + placeHolderValue + ">* ");
            this.literalBlock = false;
        }

        @Override
        public void stepCaseArgument(String caseArgumentValue) {
            this.writer.print("*" + this.escapeArgument(caseArgumentValue) + "* ");
            this.literalBlock = false;
        }

        @Override
        public void stepArgument(String argumentValue, boolean differs) {
            if (argumentValue.contains("\n")) {
                this.writer.println("\n");
                this.writer.println("[literal]");
                this.writer.println(argumentValue);
                this.writer.println();
                this.literalBlock = true;
            } else {
                this.writer.print(this.escapeArgument(argumentValue) + " ");
                this.literalBlock = false;
            }
        }

        @Override
        public void stepDataTableArgument(DataTable dataTable) {
            this.writer.print("NOT SUPPORTED IN ASCIIDOC YET");
            this.literalBlock = false;
        }

        @Override
        public void stepWord(String value, boolean differs) {
            this.writer.print(value + " ");
            this.literalBlock = false;
        }

        private String escapeTableValue(String value) {
            return this.escapeArgument(value.replace("|", "\\|"));
        }

        private String escapeArgument(String argumentValue) {
            return "pass:[" + argumentValue + "]";
        }
    }
}

