/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import java.util.List;

public class DataTable {
    private Table.HeaderType headerType;
    private List<List<String>> data;

    public DataTable(Table.HeaderType headerType, List<List<String>> data) {
        this.headerType = headerType;
        this.data = data;
    }

    public Table.HeaderType getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(Table.HeaderType headerType) {
        this.headerType = headerType;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public void setData(List<List<String>> data) {
        this.data = data;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTable dataTable = (DataTable)o;
        if (this.data != null ? !this.data.equals(dataTable.data) : dataTable.data != null) {
            return false;
        }
        return this.headerType == dataTable.headerType;
    }

    public int hashCode() {
        int result = this.headerType != null ? this.headerType.hashCode() : 0;
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public boolean hasHorizontalHeader() {
        return this.headerType == Table.HeaderType.HORIZONTAL || this.headerType == Table.HeaderType.BOTH;
    }

    public boolean hasVerticalHeader() {
        return this.headerType == Table.HeaderType.VERTICAL || this.headerType == Table.HeaderType.BOTH;
    }

    public void addColumn(int i, List<String> column) {
        AssertionUtil.assertTrue(this.data.size() == column.size(), "Column has different number of rows as expected. Is " + column.size() + ", but expected " + this.data.size());
        for (int row = 0; row < column.size(); ++row) {
            this.data.get(row).add(i, column.get(row));
        }
    }

    public int getColumnCount() {
        return this.data.get(0).size();
    }

    public void addRow(int i, List<String> row) {
        AssertionUtil.assertTrue(this.getColumnCount() == row.size(), "Row has different number of columns as expected. Is " + row.size() + ", but expected " + this.getColumnCount());
        this.data.add(i, row);
    }
}

